/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationUse;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.DocComment;
import org.mule.devkit.model.code.DocCommentable;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypedAnnotationWriter;

public final class EnumConstant
extends AbstractExpression
implements Declaration,
Annotable,
DocCommentable {
    private final String name;
    private final DefinedClass type;
    private DocComment jdoc = null;
    private List<AnnotationUse> annotations = null;
    private List<Expression> args = null;

    EnumConstant(DefinedClass type, String name) {
        this.name = name;
        this.type = type;
    }

    public EnumConstant arg(Expression arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        if (this.args == null) {
            this.args = new ArrayList<Expression>();
        }
        this.args.add(arg);
        return this;
    }

    public String getName() {
        return this.type.fullName().concat(".").concat(this.name);
    }

    @Override
    public DocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new DocComment(this.type.owner());
        }
        return this.jdoc;
    }

    @Override
    public AnnotationUse annotate(TypeReference clazz) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationUse>();
        }
        AnnotationUse a = new AnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public AnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.type.owner().ref(clazz));
    }

    @Override
    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<AnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationUse>();
        }
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public void declare(Formatter f) {
        if (this.jdoc != null) {
            f.nl().g(this.jdoc);
        }
        if (this.annotations != null) {
            for (int i = 0; i < this.annotations.size(); ++i) {
                f.g(this.annotations.get(i)).nl();
            }
        }
        f.id(this.name);
        if (this.args != null) {
            f.p('(').g(this.args).p(')');
        }
    }

    @Override
    public void generate(Formatter f) {
        f.t(this.type).p('.').p(this.name);
    }
}

