/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;

public class DoLoop
implements Statement {
    private Expression test;
    private Block body = null;

    DoLoop(Expression test) {
        this.test = test;
    }

    public Block body() {
        if (this.body == null) {
            this.body = new Block();
        }
        return this.body;
    }

    @Override
    public void state(Formatter f) {
        f.p("do");
        if (this.body != null) {
            f.g(this.body);
        } else {
            f.p("{ }");
        }
        if (Op.hasTopOp(this.test)) {
            f.p("while ").g(this.test);
        } else {
            f.p("while (").g(this.test).p(')');
        }
        f.p(';').nl();
    }
}

