/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.devkit.model.code.CaseStatement;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwitchStatement
implements Statement {
    private Expression test;
    private List<CaseStatement> cases = new ArrayList<CaseStatement>();
    private CaseStatement defaultCase = null;

    SwitchStatement(Expression test) {
        this.test = test;
    }

    public Expression test() {
        return this.test;
    }

    public Iterator<CaseStatement> cases() {
        return this.cases.iterator();
    }

    public CaseStatement _case(Expression label) {
        CaseStatement c = new CaseStatement(label);
        this.cases.add(c);
        return c;
    }

    public CaseStatement _default() {
        this.defaultCase = new CaseStatement(null, true);
        return this.defaultCase;
    }

    @Override
    public void state(Formatter f) {
        if (Op.hasTopOp(this.test)) {
            f.p("switch ").g(this.test).p(" {").nl();
        } else {
            f.p("switch (").g(this.test).p(')').p(" {").nl();
        }
        for (CaseStatement c : this.cases) {
            f.s(c);
        }
        if (this.defaultCase != null) {
            f.s(this.defaultCase);
        }
        f.p('}').nl();
    }
}

