/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;

public class Conditional
implements Statement {
    private Expression test = null;
    private Block _then = new Block();
    private Block _else = null;

    Conditional(Expression test) {
        this.test = test;
    }

    public Block _then() {
        return this._then;
    }

    public Block _else() {
        if (this._else == null) {
            this._else = new Block();
        }
        return this._else;
    }

    public Conditional _elseif(Expression boolExp) {
        return this._else()._if(boolExp);
    }

    public void state(Formatter f) {
        if (this.test == ExpressionFactory.TRUE) {
            this._then.generateBody(f);
            return;
        }
        if (this.test == ExpressionFactory.FALSE) {
            this._else.generateBody(f);
            return;
        }
        if (Op.hasTopOp(this.test)) {
            f.p("if ").g(this.test);
        } else {
            f.p("if (").g(this.test).p(')');
        }
        f.g(this._then);
        if (this._else != null) {
            f.p("else").g(this._else);
        }
        f.nl();
    }
}

