/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationUse;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.JavaName;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypedAnnotationWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable
extends AbstractExpression
implements Declaration,
AssignmentTarget,
Annotable {
    private Modifiers mods;
    private Type type;
    private String name;
    private Expression init;
    private List<AnnotationUse> annotations = null;

    Variable(Modifiers mods, Type type, String name, Expression init) {
        this.mods = mods;
        this.type = type;
        this.name = name;
        this.init = init;
    }

    public Variable init(Expression init) {
        this.init = init;
        return this;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        if (!JavaName.isJavaIdentifier(name)) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public Type type() {
        return this.type;
    }

    public Modifiers mods() {
        return this.mods;
    }

    public Type type(Type newType) {
        Type r = this.type;
        if (newType == null) {
            throw new IllegalArgumentException();
        }
        this.type = newType;
        return r;
    }

    @Override
    public AnnotationUse annotate(TypeReference clazz) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationUse>();
        }
        AnnotationUse a = new AnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public AnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.type.owner().ref(clazz));
    }

    @Override
    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<AnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationUse>();
        }
        return Collections.unmodifiableList(this.annotations);
    }

    protected boolean isAnnotated() {
        return this.annotations != null;
    }

    public void bind(Formatter f) {
        if (this.annotations != null) {
            for (int i = 0; i < this.annotations.size(); ++i) {
                f.g(this.annotations.get(i)).nl();
            }
        }
        f.g(this.mods).g(this.type).id(this.name);
        if (this.init != null) {
            f.p('=').g(this.init);
        }
    }

    @Override
    public void declare(Formatter f) {
        f.b(this).p(';').nl();
    }

    @Override
    public void generate(Formatter f) {
        f.id(this.name);
    }

    @Override
    public Expression assign(Expression rhs) {
        return ExpressionFactory.assign(this, rhs);
    }

    @Override
    public Expression assignPlus(Expression rhs) {
        return ExpressionFactory.assignPlus(this, rhs);
    }
}

