/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.Variable;

public class FieldRef
extends AbstractExpression
implements AssignmentTarget {
    private Generable object;
    private String name;
    private Variable var;
    private boolean explicitThis;

    FieldRef(Expression object, String name) {
        this((Generable)object, name, false);
    }

    FieldRef(Expression object, Variable v) {
        this((Generable)object, v, false);
    }

    FieldRef(Type type, String name) {
        this((Generable)type, name, false);
    }

    FieldRef(Type type, Variable v) {
        this((Generable)type, v, false);
    }

    FieldRef(Generable object, String name, boolean explicitThis) {
        this.explicitThis = explicitThis;
        this.object = object;
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Field name contains '.': " + name);
        }
        this.name = name;
    }

    FieldRef(Generable object, Variable var, boolean explicitThis) {
        this.explicitThis = explicitThis;
        this.object = object;
        this.var = var;
    }

    public void generate(Formatter f) {
        String name = this.name;
        if (name == null) {
            name = this.var.name();
        }
        if (this.object != null) {
            f.g(this.object).p('.').p(name);
        } else if (this.explicitThis) {
            f.p("this.").p(name);
        } else {
            f.id(name);
        }
    }

    public Expression assign(Expression rhs) {
        return ExpressionFactory.assign(this, rhs);
    }

    public Expression assignPlus(Expression rhs) {
        return ExpressionFactory.assignPlus(this, rhs);
    }
}

