/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.Collection;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentPart
extends ArrayList<Object> {
    private static final long serialVersionUID = 1L;

    public CommentPart append(Object o) {
        this.add(o);
        return this;
    }

    @Override
    public boolean add(Object o) {
        this.flattenAppend(o);
        return true;
    }

    private void flattenAppend(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                this.flattenAppend(o);
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                this.flattenAppend(o);
            }
        } else {
            super.add(value);
        }
    }

    protected void format(Formatter f, String indent) {
        if (!f.isPrinting()) {
            for (Object o : this) {
                if (!(o instanceof TypeReference)) continue;
                f.g((TypeReference)o);
            }
            return;
        }
        if (!this.isEmpty()) {
            f.p(indent);
        }
        for (Object o : this) {
            if (o instanceof String) {
                int idx;
                String s = (String)o;
                while ((idx = s.indexOf(10)) != -1) {
                    String line = s.substring(0, idx);
                    if (line.length() > 0) {
                        f.p(this.escape(line));
                    }
                    s = s.substring(idx + 1);
                    f.nl().p(indent);
                }
                if (s.length() == 0) continue;
                f.p(this.escape(s));
                continue;
            }
            if (o instanceof TypeReference) {
                ((TypeReference)o).printLink(f);
                continue;
            }
            if (o instanceof Type) {
                f.g((Type)o);
                continue;
            }
            throw new IllegalStateException();
        }
        if (!this.isEmpty()) {
            f.nl();
        }
    }

    private String escape(String s) {
        int idx;
        while ((idx = s.indexOf("*/")) >= 0) {
            s = s.substring(0, idx + 1) + "<!---->" + s.substring(idx + 1);
        }
        return s;
    }
}

