/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Statement;

public final class CaseStatement
implements Statement {
    private Expression label;
    private Block body = null;
    private boolean isDefaultCase = false;

    CaseStatement(Expression label) {
        this(label, false);
    }

    CaseStatement(Expression label, boolean isDefaultCase) {
        this.label = label;
        this.isDefaultCase = isDefaultCase;
    }

    public Expression label() {
        return this.label;
    }

    public Block body() {
        if (this.body == null) {
            this.body = new Block(false, true);
        }
        return this.body;
    }

    public void state(Formatter f) {
        f.i();
        if (!this.isDefaultCase) {
            f.p("case ").g(this.label).p(':').nl();
        } else {
            f.p("default:").nl();
        }
        if (this.body != null) {
            f.s(this.body);
        }
        f.o();
    }
}

