/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationUse;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.ClassContainer;
import org.mule.devkit.model.code.ClassType;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.DocComment;
import org.mule.devkit.model.code.DocCommentable;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.ResourceFile;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypedAnnotationWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Package
implements Declaration,
Generable,
ClassContainer,
Annotable,
Comparable<Package>,
DocCommentable {
    private String name;
    private final CodeModel owner;
    private final Map<String, DefinedClass> classes = new TreeMap<String, DefinedClass>();
    private final Set<ResourceFile> resources = new HashSet<ResourceFile>();
    private final Map<String, DefinedClass> upperCaseClassMap;
    private List<AnnotationUse> annotations = null;
    private DocComment jdoc = null;

    Package(String name, CodeModel cw) {
        this.owner = cw;
        if (name.equals(".")) {
            String msg = "Package name . is not allowed";
            throw new IllegalArgumentException(msg);
        }
        this.upperCaseClassMap = CodeModel.isCaseSensitiveFileSystem ? null : new HashMap<String, DefinedClass>();
        this.name = name;
    }

    @Override
    public ClassContainer parentContainer() {
        return this.parent();
    }

    public Package parent() {
        if (this.name.length() == 0) {
            return null;
        }
        int idx = this.name.lastIndexOf(46);
        return this.owner._package(this.name.substring(0, idx));
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    public Package getPackage() {
        return this;
    }

    @Override
    public DefinedClass _class(int mods, String name) throws ClassAlreadyExistsException {
        return this._class(mods, name, ClassType.CLASS);
    }

    @Override
    public DefinedClass _class(int mods, String name, boolean isInterface) throws ClassAlreadyExistsException {
        return this._class(mods, name, isInterface ? ClassType.INTERFACE : ClassType.CLASS);
    }

    @Override
    public DefinedClass _class(int mods, String name, ClassType classTypeVal) throws ClassAlreadyExistsException {
        if (this.classes.containsKey(name)) {
            throw new ClassAlreadyExistsException(this.classes.get(name));
        }
        DefinedClass c = new DefinedClass(this, mods, name, classTypeVal);
        if (this.upperCaseClassMap != null) {
            DefinedClass dc = this.upperCaseClassMap.get(name.toUpperCase());
            if (dc != null) {
                throw new ClassAlreadyExistsException(dc);
            }
            this.upperCaseClassMap.put(name.toUpperCase(), c);
        }
        this.classes.put(name, c);
        return c;
    }

    @Override
    public DefinedClass _class(String name) {
        try {
            return this._class(1, name);
        }
        catch (ClassAlreadyExistsException ee) {
            return ee.getExistingClass();
        }
    }

    public DefinedClass _class(String name, TypeReference _extends) {
        try {
            DefinedClass clazz = this._class(1, name);
            clazz._extends(_extends);
            return clazz;
        }
        catch (ClassAlreadyExistsException ee) {
            return ee.getExistingClass();
        }
    }

    public DefinedClass _class(String name, Class<?> _extends) {
        try {
            DefinedClass clazz = this._class(1, name);
            clazz._extends(_extends);
            return clazz;
        }
        catch (ClassAlreadyExistsException ee) {
            return ee.getExistingClass();
        }
    }

    public DefinedClass _class(String name, Class<?> _extends, Class<?>[] _implements) {
        try {
            DefinedClass clazz = this._class(1, name);
            clazz._extends(_extends);
            for (Class<?> _implement : _implements) {
                clazz._implements(_implement);
            }
            return clazz;
        }
        catch (ClassAlreadyExistsException ee) {
            return ee.getExistingClass();
        }
    }

    public DefinedClass _class(String name, Class<?>[] _implements) {
        try {
            DefinedClass clazz = this._class(1, name);
            for (Class<?> _implement : _implements) {
                clazz._implements(_implement);
            }
            return clazz;
        }
        catch (ClassAlreadyExistsException ee) {
            return ee.getExistingClass();
        }
    }

    public DefinedClass _getClass(String name) {
        if (this.classes.containsKey(name)) {
            return this.classes.get(name);
        }
        return null;
    }

    @Override
    public int compareTo(Package that) {
        return this.name.compareTo(that.name);
    }

    @Override
    public DefinedClass _interface(int mods, String name) throws ClassAlreadyExistsException {
        return this._class(mods, name, ClassType.INTERFACE);
    }

    @Override
    public DefinedClass _interface(String name) throws ClassAlreadyExistsException {
        return this._interface(1, name);
    }

    @Override
    public DefinedClass _annotationTypeDeclaration(String name) throws ClassAlreadyExistsException {
        return this._class(1, name, ClassType.ANNOTATION_TYPE_DECL);
    }

    @Override
    public DefinedClass _enum(String name) throws ClassAlreadyExistsException {
        return this._class(1, name, ClassType.ENUM);
    }

    public ResourceFile addResourceFile(ResourceFile rsrc) {
        this.resources.add(rsrc);
        return rsrc;
    }

    public boolean hasResourceFile(String name) {
        for (ResourceFile r : this.resources) {
            if (!r.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Iterator<ResourceFile> propertyFiles() {
        return this.resources.iterator();
    }

    @Override
    public DocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new DocComment(this.owner());
        }
        return this.jdoc;
    }

    public void remove(TypeReference c) {
        if (c._package() != this) {
            throw new IllegalArgumentException("the specified class is not a member of this package, or it is a referenced class");
        }
        this.classes.remove(c.name());
        if (this.upperCaseClassMap != null) {
            this.upperCaseClassMap.remove(c.name().toUpperCase());
        }
    }

    public TypeReference ref(String name) throws ClassNotFoundException {
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("TypeReference name contains '.': " + name);
        }
        String n = "";
        if (!this.isUnnamed()) {
            n = this.name + '.';
        }
        n = n + name;
        return this.owner.ref(Class.forName(n));
    }

    public Package subPackage(String pkg) {
        if (this.isUnnamed()) {
            return this.owner()._package(pkg);
        }
        return this.owner()._package(this.name + '.' + pkg);
    }

    @Override
    public Iterator<DefinedClass> classes() {
        return this.classes.values().iterator();
    }

    public boolean isDefined(String classLocalName) {
        Iterator<DefinedClass> itr = this.classes();
        while (itr.hasNext()) {
            if (!itr.next().name().equals(classLocalName)) continue;
            return true;
        }
        return false;
    }

    public final boolean isUnnamed() {
        return this.name.length() == 0;
    }

    public String name() {
        return this.name;
    }

    @Override
    public final CodeModel owner() {
        return this.owner;
    }

    @Override
    public AnnotationUse annotate(TypeReference clazz) {
        if (this.isUnnamed()) {
            throw new IllegalArgumentException("the root package cannot be annotated");
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationUse>();
        }
        AnnotationUse a = new AnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public AnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner.ref(clazz));
    }

    @Override
    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<AnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationUse>();
        }
        return Collections.unmodifiableList(this.annotations);
    }

    File toPath(File dir) {
        if (this.name == null) {
            return dir;
        }
        return new File(dir, this.name.replace('.', File.separatorChar));
    }

    @Override
    public void declare(Formatter f) {
        if (this.name.length() != 0) {
            f.p("package").p(this.name).p(';').nl();
        }
    }

    @Override
    public void generate(Formatter f) {
        f.p(this.name);
    }

    void build(CodeWriter src, CodeWriter res) throws IOException {
        for (DefinedClass c : this.classes.values()) {
            if (c.isHidden()) continue;
            Formatter f = this.createJavaSourceFileWriter(src, c.name());
            f.write(c);
            f.close();
        }
        if (this.annotations != null || this.jdoc != null) {
            Formatter f = this.createJavaSourceFileWriter(src, "package-info");
            if (this.jdoc != null) {
                f.g(this.jdoc);
            }
            if (this.annotations != null) {
                for (AnnotationUse a : this.annotations) {
                    f.g(a).nl();
                }
            }
            f.d(this);
            f.close();
        }
        for (ResourceFile rsrc : this.resources) {
            CodeWriter cw = rsrc.isResource() ? res : src;
            BufferedOutputStream os = new BufferedOutputStream(cw.openBinary(this, rsrc.name()));
            rsrc.build(os);
            ((OutputStream)os).close();
        }
    }

    int countArtifacts() {
        int r = 0;
        for (DefinedClass c : this.classes.values()) {
            if (c.isHidden()) continue;
            ++r;
        }
        if (this.annotations != null || this.jdoc != null) {
            ++r;
        }
        return r += this.resources.size();
    }

    private Formatter createJavaSourceFileWriter(CodeWriter src, String className) throws IOException {
        BufferedWriter bw = new BufferedWriter(src.openSource(this, className + ".java"));
        return new Formatter(new PrintWriter(bw));
    }
}

