/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.AnonymousClass;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;

public final class Invocation
extends AbstractExpression
implements Statement {
    private Generable object;
    private String name;
    private Method method;
    private boolean isConstructor;
    private List<Expression> args = new ArrayList<Expression>();
    private Type type;

    Invocation(Expression object, String name) {
        this((Generable)object, name);
    }

    Invocation(Expression object, Method method) {
        this((Generable)object, method);
    }

    Invocation(TypeReference type, String name) {
        this((Generable)type, name);
    }

    Invocation(TypeReference type, Method method) {
        this((Generable)type, method);
    }

    private Invocation(Generable object, String name) {
        this.object = object;
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("method name contains '.': " + name);
        }
        this.name = name;
    }

    private Invocation(Generable object, Method method) {
        this.object = object;
        this.method = method;
    }

    Invocation(Type c) {
        this.isConstructor = true;
        this.type = c;
    }

    public Invocation arg(Expression arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        this.args.add(arg);
        return this;
    }

    public Invocation arg(String v) {
        return this.arg(ExpressionFactory.lit(v));
    }

    public Expression[] listArgs() {
        return this.args.toArray(new Expression[this.args.size()]);
    }

    public void generate(Formatter f) {
        if (this.isConstructor && this.type == null) {
            throw new IllegalStateException("Cannot generate this invocation: " + this);
        }
        if (this.isConstructor && this.type.isArray()) {
            f.p("new").g(this.type).p('{');
        } else if (this.isConstructor) {
            f.p("new").g(this.type).p('(');
        } else {
            String name = this.name;
            if (name == null) {
                name = this.method.name();
            }
            if (this.object != null) {
                f.g(this.object).p('.').p(name).p('(');
            } else {
                f.id(name).p('(');
            }
        }
        f.g(this.args);
        if (this.isConstructor && this.type.isArray()) {
            f.p('}');
        } else {
            f.p(')');
        }
        if (this.type instanceof DefinedClass && ((DefinedClass)this.type).isAnonymous()) {
            ((AnonymousClass)this.type).declareBody(f);
        }
    }

    public void state(Formatter f) {
        f.g(this).p(';').nl();
    }

    public String toString() {
        return "Invocation{object=" + this.object + ", name='" + this.name + '\'' + ", method=" + this.method + ", isConstructor=" + this.isConstructor + ", args=" + this.args + ", type=" + this.type + '}';
    }
}

