/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;

public class WhileLoop
implements Statement {
    private Expression test;
    private Block body = null;

    WhileLoop(Expression test) {
        this.test = test;
    }

    public Expression test() {
        return this.test;
    }

    public Block body() {
        if (this.body == null) {
            this.body = new Block();
        }
        return this.body;
    }

    public void state(Formatter f) {
        if (Op.hasTopOp(this.test)) {
            f.p("while ").g(this.test);
        } else {
            f.p("while (").g(this.test).p(')');
        }
        if (this.body != null) {
            f.s(this.body);
        } else {
            f.p(';').nl();
        }
    }
}

