/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.mule.devkit.model.code.AbstractGenerifiable;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedJavaDocComment;
import org.mule.devkit.model.code.GeneratedParam;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypedAnnotationWriter;
import org.mule.devkit.model.code.util.ClassNameComparator;

public class GeneratedMethod
extends AbstractGenerifiable
implements Declaration,
Annotable,
Documentable {
    private Modifiers mods;
    private Type type = null;
    private String name = null;
    private final List<GeneratedVariable> params = new ArrayList<GeneratedVariable>();
    private Set<TypeReference> _throws;
    private GeneratedBlock body = null;
    private GeneratedClass outer;
    private GeneratedJavaDocComment jdoc = null;
    private GeneratedVariable varParam = null;
    private List<GeneratedAnnotationUse> annotations = null;
    private GeneratedExpression defaultValue = null;

    private boolean isConstructor() {
        return this.type == null;
    }

    GeneratedMethod(GeneratedClass outer, int mods, Type type, String name) {
        this.mods = Modifiers.forMethod(mods);
        this.type = type;
        this.name = name;
        this.outer = outer;
    }

    GeneratedMethod(int mods, GeneratedClass _class) {
        this.mods = Modifiers.forMethod(mods);
        this.type = null;
        this.name = _class.name();
        this.outer = _class;
    }

    private Set<TypeReference> getThrows() {
        if (this._throws == null) {
            this._throws = new TreeSet<TypeReference>(ClassNameComparator.theInstance);
        }
        return this._throws;
    }

    public GeneratedMethod _throws(TypeReference exception) {
        this.getThrows().add(exception);
        return this;
    }

    public GeneratedMethod _throws(Class<? extends Throwable> exception) {
        return this._throws(this.outer.owner().ref(exception));
    }

    public List<GeneratedVariable> params() {
        return Collections.unmodifiableList(this.params);
    }

    public GeneratedVariable param(int mods, Type type, String name) {
        GeneratedParam v = new GeneratedParam(Modifiers.forVar(mods), type, name, null);
        this.params.add(v);
        return v;
    }

    public GeneratedVariable param(Type type, String name) {
        return this.param(0, type, name);
    }

    public GeneratedVariable param(int mods, Class<?> type, String name) {
        return this.param(mods, this.outer.owner()._ref(type), name);
    }

    public GeneratedVariable param(Class<?> type, String name) {
        return this.param(this.outer.owner()._ref(type), name);
    }

    public GeneratedVariable varParam(Class<?> type, String name) {
        return this.varParam(this.outer.owner()._ref(type), name);
    }

    public GeneratedVariable varParam(Type type, String name) {
        if (!this.hasVarArgs()) {
            this.varParam = new GeneratedVariable(Modifiers.forVar(0), type.array(), name, null);
            return this.varParam;
        }
        throw new IllegalStateException("Cannot have two varargs in a method,\nCheck if varParam method of Method is invoked more than once");
    }

    @Override
    public GeneratedAnnotationUse annotate(TypeReference clazz) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        GeneratedAnnotationUse a = new GeneratedAnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public GeneratedAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner().ref(clazz));
    }

    @Override
    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<GeneratedAnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        return Collections.unmodifiableList(this.annotations);
    }

    public boolean hasVarArgs() {
        return this.varParam != null;
    }

    public String name() {
        return this.name;
    }

    public void name(String n) {
        this.name = n;
    }

    public Type type() {
        return this.type;
    }

    public void type(Type t) {
        this.type = t;
    }

    public Type[] listParamTypes() {
        Type[] r = new Type[this.params.size()];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.params.get(i).type();
        }
        return r;
    }

    public Type listVarParamType() {
        if (this.varParam != null) {
            return this.varParam.type();
        }
        return null;
    }

    public GeneratedVariable[] listParams() {
        return this.params.toArray(new GeneratedVariable[this.params.size()]);
    }

    public GeneratedVariable listVarParam() {
        return this.varParam;
    }

    public boolean hasSignature(Type[] argTypes) {
        GeneratedVariable[] p = this.listParams();
        if (p.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i].type().equals(argTypes[i])) continue;
            return false;
        }
        return true;
    }

    public GeneratedBlock body() {
        if (this.body == null) {
            this.body = new GeneratedBlock();
        }
        return this.body;
    }

    public void declareDefaultValue(GeneratedExpression value) {
        this.defaultValue = value;
    }

    @Override
    public GeneratedJavaDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new GeneratedJavaDocComment(this.owner());
        }
        return this.jdoc;
    }

    @Override
    public void declare(Formatter f) {
        if (this.jdoc != null) {
            f.g(this.jdoc);
        }
        if (this.annotations != null) {
            for (GeneratedAnnotationUse a : this.annotations) {
                f.g(a).nl();
            }
        }
        f.g(this.mods);
        super.declare(f);
        if (!this.isConstructor()) {
            f.g(this.type);
        }
        f.id(this.name).p('(').i();
        boolean first = true;
        for (GeneratedVariable var : this.params) {
            if (!first) {
                f.p(',');
            }
            f.b(var);
            first = false;
        }
        if (this.hasVarArgs()) {
            if (!first) {
                f.p(',');
            }
            f.g(this.varParam.type().elementType());
            f.p("... ");
            f.id(this.varParam.name());
        }
        f.o().p(')');
        if (this._throws != null && !this._throws.isEmpty()) {
            f.nl().i().p("throws").g(this._throws).nl().o();
        }
        if (this.defaultValue != null) {
            f.p("default ");
            f.g(this.defaultValue);
        }
        if (this.body != null) {
            f.s(this.body);
        } else if (!(this.outer.isInterface() || this.outer.isAnnotationTypeDeclaration() || this.mods.isAbstract() || this.mods.isNative())) {
            f.s(new GeneratedBlock());
        } else {
            f.p(';').nl();
        }
    }

    public Modifiers mods() {
        return this.mods;
    }

    public Modifiers getMods() {
        return this.mods;
    }

    @Override
    protected CodeModel owner() {
        return this.outer.owner();
    }
}

