/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.mule.devkit.model.code;


/**
 * A Java expression.
 * <p/>
 * <p/>
 * Unlike most of CodeModel, JExpressions are built bottom-up (
 * meaning you start from leaves and then gradually build compliated expressions
 * by combining them.)
 * <p/>
 * <p/>
 * {@link GeneratedExpression} defines a series of composer methods,
 * which returns a complicated expression (by often taking other {@link GeneratedExpression}s
 * as parameters.
 * For example, you can build "5+2" by
 * <tt>ExpressionFactory.lit(5).add(ExpressionFactory.lit(2))</tt>
 */
public interface GeneratedExpression extends Generable {
    /**
     * Returns "-[this]" from "[this]".
     */
    GeneratedExpression minus();

    /**
     * Returns "![this]" from "[this]".
     */
    GeneratedExpression not();

    /**
     * Returns "~[this]" from "[this]".
     */
    GeneratedExpression complement();

    /**
     * Returns "[this]++" from "[this]".
     */
    GeneratedExpression incr();

    /**
     * Returns "[this]--" from "[this]".
     */
    GeneratedExpression decr();

    /**
     * Returns "[this]+[right]"
     */
    GeneratedExpression plus(GeneratedExpression right);

    /**
     * Returns "[this]-[right]"
     */
    GeneratedExpression minus(GeneratedExpression right);

    /**
     * Returns "[this]*[right]"
     */
    GeneratedExpression mul(GeneratedExpression right);

    /**
     * Returns "[this]/[right]"
     */
    GeneratedExpression div(GeneratedExpression right);

    /**
     * Returns "[this]%[right]"
     */
    GeneratedExpression mod(GeneratedExpression right);

    /**
     * Returns "[this]&lt;&lt;[right]"
     */
    GeneratedExpression shl(GeneratedExpression right);

    /**
     * Returns "[this]>>[right]"
     */
    GeneratedExpression shr(GeneratedExpression right);

    /**
     * Returns "[this]>>>[right]"
     */
    GeneratedExpression shrz(GeneratedExpression right);

    /**
     * Bit-wise AND '&amp;'.
     */
    GeneratedExpression band(GeneratedExpression right);

    /**
     * Bit-wise OR '|'.
     */
    GeneratedExpression bor(GeneratedExpression right);

    /**
     * Logical AND '&amp;&amp;'.
     */
    GeneratedExpression cand(GeneratedExpression right);

    /**
     * Logical OR '||'.
     */
    GeneratedExpression cor(GeneratedExpression right);

    GeneratedExpression xor(GeneratedExpression right);

    GeneratedExpression lt(GeneratedExpression right);

    GeneratedExpression lte(GeneratedExpression right);

    GeneratedExpression gt(GeneratedExpression right);

    GeneratedExpression gte(GeneratedExpression right);

    GeneratedExpression eq(GeneratedExpression right);

    GeneratedExpression ne(GeneratedExpression right);

    /**
     * Returns "[this] instanceof [right]"
     */
    GeneratedExpression _instanceof(Type right);

    /**
     * Returns "[this].[method]".
     * <p/>
     * Arguments shall be added to the returned {@link GeneratedInvocation} object.
     */
    GeneratedInvocation invoke(GeneratedMethod method);

    /**
     * Returns "[this].[method]".
     * <p/>
     * Arguments shall be added to the returned {@link GeneratedInvocation} object.
     */
    GeneratedInvocation invoke(String method);

    GeneratedFieldReference ref(GeneratedVariable field);

    GeneratedFieldReference ref(String field);

    ArrayCompRef component(GeneratedExpression index);

    GeneratedExpression isNull();

    GeneratedExpression isNotNull();
}
