/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.ArrayCompRef;
import org.mule.devkit.model.code.Assignment;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Atom;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedArray;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedFieldReference;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.NarrowedClass;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.StringLiteral;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;

public abstract class ExpressionFactory {
    private static final GeneratedExpression __this = new Atom("this");
    private static final GeneratedExpression __super = new Atom("super");
    private static final GeneratedExpression __null = new Atom("null");
    public static final GeneratedExpression TRUE = new Atom("true");
    public static final GeneratedExpression FALSE = new Atom("false");
    static final String charEscape = "\b\t\n\f\r\"'\\";
    static final String charMacro = "btnfr\"'\\";

    private ExpressionFactory() {
    }

    public static GeneratedExpression assign(AssignmentTarget lhs, GeneratedExpression rhs) {
        return new Assignment(lhs, rhs);
    }

    public static GeneratedExpression assignPlus(AssignmentTarget lhs, GeneratedExpression rhs) {
        return new Assignment(lhs, rhs, "+");
    }

    public static GeneratedInvocation _new(TypeReference c) {
        return new GeneratedInvocation(c);
    }

    public static GeneratedInvocation _new(Type t) {
        return new GeneratedInvocation(t);
    }

    public static GeneratedInvocation invoke(String method) {
        return new GeneratedInvocation((GeneratedExpression)null, method);
    }

    public static GeneratedInvocation invoke(GeneratedMethod method) {
        return new GeneratedInvocation((GeneratedExpression)null, method);
    }

    public static GeneratedInvocation invoke(GeneratedExpression lhs, GeneratedMethod method) {
        return new GeneratedInvocation(lhs, method);
    }

    public static GeneratedInvocation invoke(GeneratedExpression lhs, String method) {
        return new GeneratedInvocation(lhs, method);
    }

    public static GeneratedFieldReference ref(String field) {
        return new GeneratedFieldReference((GeneratedExpression)null, field);
    }

    public static GeneratedFieldReference ref(GeneratedExpression lhs, GeneratedVariable field) {
        return new GeneratedFieldReference(lhs, field);
    }

    public static GeneratedFieldReference ref(GeneratedExpression lhs, String field) {
        return new GeneratedFieldReference(lhs, field);
    }

    public static GeneratedFieldReference refthis(String field) {
        return new GeneratedFieldReference(null, field, true);
    }

    public static GeneratedExpression dotclass(final Type cl) {
        return new AbstractExpression(){

            @Override
            public void generate(Formatter f) {
                Type c = cl instanceof NarrowedClass ? ((NarrowedClass)cl).basis : cl;
                f.g(c).p(".class");
            }
        };
    }

    public static ArrayCompRef component(GeneratedExpression lhs, GeneratedExpression index) {
        return new ArrayCompRef(lhs, index);
    }

    public static GeneratedCast cast(Type type, GeneratedExpression expr) {
        return new GeneratedCast(type, expr);
    }

    public static GeneratedArray newArray(Type type) {
        return ExpressionFactory.newArray(type, null);
    }

    public static GeneratedArray newArray(Type type, GeneratedExpression size) {
        return new GeneratedArray(type.erasure(), size);
    }

    public static GeneratedArray newArray(Type type, int size) {
        return ExpressionFactory.newArray(type, ExpressionFactory.lit(size));
    }

    public static GeneratedExpression _this() {
        return __this;
    }

    public static GeneratedExpression _super() {
        return __super;
    }

    public static GeneratedExpression _null() {
        return __null;
    }

    public static GeneratedExpression lit(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static GeneratedExpression lit(int n) {
        return new Atom(Integer.toString(n));
    }

    public static GeneratedExpression lit(long n) {
        return new Atom(Long.toString(n) + "L");
    }

    public static GeneratedExpression lit(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return new Atom("java.lang.Float.NEGATIVE_INFINITY");
        }
        if (f == Float.POSITIVE_INFINITY) {
            return new Atom("java.lang.Float.POSITIVE_INFINITY");
        }
        if (Float.isNaN(f)) {
            return new Atom("java.lang.Float.NaN");
        }
        return new Atom(Float.toString(f) + "F");
    }

    public static GeneratedExpression lit(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return new Atom("java.lang.Double.NEGATIVE_INFINITY");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return new Atom("java.lang.Double.POSITIVE_INFINITY");
        }
        if (Double.isNaN(d)) {
            return new Atom("java.lang.Double.NaN");
        }
        return new Atom(Double.toString(d) + "D");
    }

    public static String quotify(char quote, String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n + 2);
        sb.append(quote);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int j = charEscape.indexOf(c);
            if (j >= 0) {
                if (quote == '\"' && c == '\'' || quote == '\'' && c == '\"') {
                    sb.append(c);
                    continue;
                }
                sb.append('\\');
                sb.append(charMacro.charAt(j));
                continue;
            }
            if (c < ' ' || '~' < c) {
                sb.append("\\u");
                String hex = Integer.toHexString(c & 0xFFFF);
                for (int k = hex.length(); k < 4; ++k) {
                    sb.append('0');
                }
                sb.append(hex);
                continue;
            }
            sb.append(c);
        }
        sb.append(quote);
        return sb.toString();
    }

    public static GeneratedExpression lit(char c) {
        return new Atom(ExpressionFactory.quotify('\'', "" + c));
    }

    public static GeneratedExpression lit(String s) {
        return new StringLiteral(s);
    }

    public static GeneratedExpression direct(final String source) {
        return new AbstractExpression(){

            @Override
            public void generate(Formatter f) {
                f.p('(').p(source).p(')');
            }
        };
    }

    public static Statement inlineComment(final String comment) {
        return new Statement(){

            @Override
            public void state(Formatter f) {
                f.p("// " + comment).nl();
            }
        };
    }
}

