/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.util.EncoderFactory;
import org.mule.devkit.model.code.util.UnicodeEscapeWriter;

public abstract class CodeWriter {
    public abstract OutputStream openBinary(GeneratedPackage var1, String var2) throws IOException;

    public Writer openSource(GeneratedPackage pkg, String fileName) throws IOException {
        final OutputStreamWriter bw = new OutputStreamWriter(this.openBinary(pkg, fileName));
        try {
            return new UnicodeEscapeWriter(bw){
                private final CharsetEncoder encoder;
                {
                    super(next);
                    this.encoder = EncoderFactory.createEncoder(bw.getEncoding());
                }

                @Override
                protected boolean requireEscaping(int ch) {
                    if (ch < 32 && " \t\r\n".indexOf(ch) == -1) {
                        return true;
                    }
                    if (ch < 128) {
                        return false;
                    }
                    return !this.encoder.canEncode((char)ch);
                }
            };
        }
        catch (Throwable t) {
            return new UnicodeEscapeWriter(bw);
        }
    }

    public abstract void close() throws IOException;
}

