/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;

class NarrowedClass
extends TypeReference {
    final TypeReference basis;
    private List<TypeReference> args;
    private String generify = "";

    NarrowedClass(TypeReference basis, TypeReference arg) {
        this(basis, Collections.singletonList(arg));
    }

    NarrowedClass(TypeReference basis, String generify) {
        super(basis.owner());
        this.basis = basis;
        this.generify = generify;
        this.args = Arrays.asList(new TypeReference[0]);
    }

    NarrowedClass(TypeReference basis, List<TypeReference> args) {
        super(basis.owner());
        this.basis = basis;
        assert (!(basis instanceof NarrowedClass));
        this.args = args;
    }

    @Override
    public TypeReference narrow(TypeReference clazz) {
        ArrayList<TypeReference> newArgs = new ArrayList<TypeReference>(this.args);
        newArgs.add(clazz);
        return new NarrowedClass(this.basis, newArgs);
    }

    @Override
    public TypeReference narrow(TypeReference ... clazz) {
        ArrayList<TypeReference> newArgs = new ArrayList<TypeReference>(this.args);
        newArgs.addAll(Arrays.asList(clazz));
        return new NarrowedClass(this.basis, newArgs);
    }

    @Override
    public String name() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.basis.name());
        buf.append('<');
        if (!StringUtils.isEmpty((String)this.generify)) {
            buf.append(this.generify);
        }
        boolean first = true;
        for (TypeReference c : this.args) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(c.name());
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public String fullName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.basis.fullName());
        buf.append('<');
        if (!StringUtils.isEmpty((String)this.generify)) {
            buf.append(this.generify);
        }
        boolean first = true;
        for (TypeReference c : this.args) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(c.fullName());
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public String binaryName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.basis.binaryName());
        buf.append('<');
        if (!StringUtils.isEmpty((String)this.generify)) {
            buf.append(this.generify);
        }
        boolean first = true;
        for (TypeReference c : this.args) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(c.binaryName());
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public void generate(Formatter f) {
        f.t(this.basis).p('<' + this.generify).g(this.args).p('\uffff');
    }

    @Override
    void printLink(Formatter f) {
        this.basis.printLink(f);
        f.p("{@code <}");
        boolean first = true;
        for (TypeReference c : this.args) {
            if (first) {
                first = false;
            } else {
                f.p(',');
            }
            c.printLink(f);
        }
        f.p("{@code >}");
    }

    @Override
    public GeneratedPackage _package() {
        return this.basis._package();
    }

    @Override
    public TypeReference _extends() {
        TypeReference base = this.basis._extends();
        if (base == null) {
            return base;
        }
        return base.substituteParams(this.basis.typeParams(), this.args);
    }

    @Override
    public Iterator<TypeReference> _implements() {
        return new Iterator<TypeReference>(){
            private final Iterator<TypeReference> core;
            {
                this.core = NarrowedClass.this.basis._implements();
            }

            @Override
            public void remove() {
                this.core.remove();
            }

            @Override
            public TypeReference next() {
                return this.core.next().substituteParams(NarrowedClass.this.basis.typeParams(), NarrowedClass.this.args);
            }

            @Override
            public boolean hasNext() {
                return this.core.hasNext();
            }
        };
    }

    @Override
    public TypeReference erasure() {
        return this.basis;
    }

    @Override
    public boolean isInterface() {
        return this.basis.isInterface();
    }

    @Override
    public boolean isAbstract() {
        return this.basis.isAbstract();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NarrowedClass)) {
            return false;
        }
        return this.fullName().equals(((TypeReference)obj).fullName());
    }

    @Override
    public int hashCode() {
        return this.fullName().hashCode();
    }

    @Override
    protected TypeReference substituteParams(TypeVariable[] variables, List<TypeReference> bindings) {
        TypeReference b = this.basis.substituteParams(variables, bindings);
        boolean different = b != this.basis;
        ArrayList<TypeReference> clazz = new ArrayList<TypeReference>(this.args.size());
        for (int i = 0; i < clazz.size(); ++i) {
            TypeReference c = this.args.get(i).substituteParams(variables, bindings);
            clazz.set(i, c);
            different |= c != this.args.get(i);
        }
        if (different) {
            return new NarrowedClass(b, clazz);
        }
        return this;
    }

    @Override
    public List<TypeReference> getTypeParameters() {
        return this.args;
    }
}

