/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.GeneratedAnonymousClass;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;

public final class GeneratedInvocation
extends AbstractExpression
implements Statement {
    private Generable object;
    private String name;
    private GeneratedMethod method;
    private boolean isConstructor;
    private List<GeneratedExpression> args = new ArrayList<GeneratedExpression>();
    private Type type;

    GeneratedInvocation(GeneratedExpression object, String name) {
        this((Generable)object, name);
    }

    GeneratedInvocation(GeneratedExpression object, GeneratedMethod method) {
        this((Generable)object, method);
    }

    GeneratedInvocation(TypeReference type, String name) {
        this((Generable)type, name);
    }

    GeneratedInvocation(TypeReference type, GeneratedMethod method) {
        this((Generable)type, method);
    }

    private GeneratedInvocation(Generable object, String name) {
        this.object = object;
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("method name contains '.': " + name);
        }
        this.name = name;
    }

    private GeneratedInvocation(Generable object, GeneratedMethod method) {
        this.object = object;
        this.method = method;
    }

    GeneratedInvocation(Type c) {
        this.isConstructor = true;
        this.type = c;
    }

    public GeneratedInvocation arg(GeneratedExpression arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        this.args.add(arg);
        return this;
    }

    public GeneratedInvocation arg(String v) {
        return this.arg(ExpressionFactory.lit(v));
    }

    public GeneratedExpression[] listArgs() {
        return this.args.toArray(new GeneratedExpression[this.args.size()]);
    }

    @Override
    public void generate(Formatter f) {
        if (this.isConstructor && this.type == null) {
            throw new IllegalStateException("Cannot generate this invocation: " + this);
        }
        if (this.isConstructor && this.type.isArray()) {
            f.p("new").g(this.type).p('{');
        } else if (this.isConstructor) {
            f.p("new").g(this.type).p('(');
        } else {
            String name = this.name;
            if (name == null) {
                name = this.method.name();
            }
            if (this.object != null) {
                f.g(this.object).p('.').p(name).p('(');
            } else {
                f.id(name).p('(');
            }
        }
        f.g(this.args);
        if (this.isConstructor && this.type.isArray()) {
            f.p('}');
        } else {
            f.p(')');
        }
        if (this.type instanceof GeneratedClass && ((GeneratedClass)this.type).isAnonymous()) {
            ((GeneratedAnonymousClass)this.type).declareBody(f);
        }
    }

    @Override
    public void state(Formatter f) {
        f.g(this).p(';').nl();
    }

    public String toString() {
        return "Invocation{object=" + this.object + ", name='" + this.name + '\'' + ", method=" + this.method + ", isConstructor=" + this.isConstructor + ", args=" + this.args + ", type=" + this.type + '}';
    }
}

