/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;

public class GeneratedWhileLoop
implements Statement {
    private GeneratedExpression test;
    private GeneratedBlock body = null;

    GeneratedWhileLoop(GeneratedExpression test) {
        this.test = test;
    }

    public GeneratedExpression test() {
        return this.test;
    }

    public GeneratedBlock body() {
        if (this.body == null) {
            this.body = new GeneratedBlock();
        }
        return this.body;
    }

    public void state(Formatter f) {
        if (Op.hasTopOp(this.test)) {
            f.p("while ").g(this.test);
        } else {
            f.p("while (").g(this.test).p(')');
        }
        if (this.body != null) {
            f.s(this.body);
        } else {
            f.p(';').nl();
        }
    }
}

