/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.ClassContainer;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedClassType;
import org.mule.devkit.model.code.GeneratedJavaDocComment;
import org.mule.devkit.model.code.ResourceFile;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypedAnnotationWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneratedPackage
implements Declaration,
Generable,
ClassContainer,
Annotable,
Comparable<GeneratedPackage>,
Documentable {
    private String name;
    private final CodeModel owner;
    private final Map<String, GeneratedClass> classes = new TreeMap<String, GeneratedClass>();
    private final Set<ResourceFile> resources = new HashSet<ResourceFile>();
    private final Map<String, GeneratedClass> upperCaseClassMap;
    private List<GeneratedAnnotationUse> annotations = null;
    private GeneratedJavaDocComment jdoc = null;

    GeneratedPackage(String name, CodeModel cw) {
        this.owner = cw;
        if (name.equals(".")) {
            String msg = "Package name . is not allowed";
            throw new IllegalArgumentException(msg);
        }
        this.upperCaseClassMap = CodeModel.isCaseSensitiveFileSystem ? null : new HashMap<String, GeneratedClass>();
        this.name = name;
    }

    @Override
    public ClassContainer parentContainer() {
        return this.parent();
    }

    public GeneratedPackage parent() {
        if (this.name.length() == 0) {
            return null;
        }
        int idx = this.name.lastIndexOf(46);
        return this.owner._package(this.name.substring(0, idx));
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    public GeneratedPackage getPackage() {
        return this;
    }

    @Override
    public GeneratedClass _class(int mods, String name) {
        try {
            return this._class(mods, name, GeneratedClassType.CLASS);
        }
        catch (ClassAlreadyExistsException caee) {
            return caee.getExistingClass();
        }
    }

    @Override
    public GeneratedClass _class(int mods, String name, boolean isInterface) throws ClassAlreadyExistsException {
        return this._class(mods, name, isInterface ? GeneratedClassType.INTERFACE : GeneratedClassType.CLASS);
    }

    @Override
    public GeneratedClass _class(int mods, String name, GeneratedClassType classTypeVal) throws ClassAlreadyExistsException {
        if (this.classes.containsKey(name)) {
            throw new ClassAlreadyExistsException(this.classes.get(name));
        }
        GeneratedClass c = new GeneratedClass(this, mods, name, classTypeVal);
        if (this.upperCaseClassMap != null) {
            GeneratedClass dc = this.upperCaseClassMap.get(name.toUpperCase());
            if (dc != null) {
                throw new ClassAlreadyExistsException(dc);
            }
            this.upperCaseClassMap.put(name.toUpperCase(), c);
        }
        this.classes.put(name, c);
        return c;
    }

    @Override
    public GeneratedClass _class(String name) {
        return this._class(1, name);
    }

    public GeneratedClass _class(String name, TypeReference _extends) {
        return this._class(1, name, _extends);
    }

    public GeneratedClass _class(int modifiers, String name, TypeReference _extends) {
        GeneratedClass clazz = this._class(modifiers, name);
        clazz._extends(_extends);
        return clazz;
    }

    public GeneratedClass _class(String name, Class<?> _extends) {
        GeneratedClass clazz = this._class(1, name);
        clazz._extends(_extends);
        return clazz;
    }

    public GeneratedClass _class(String name, Class<?> _extends, Class<?>[] _implements) {
        GeneratedClass clazz = this._class(1, name);
        clazz._extends(_extends);
        for (Class<?> _implement : _implements) {
            clazz._implements(_implement);
        }
        return clazz;
    }

    public GeneratedClass _class(int modifiers, String name, Class<?> _extends, Class<?>[] _implements) {
        GeneratedClass clazz = this._class(modifiers, name);
        clazz._extends(_extends);
        for (Class<?> _implement : _implements) {
            clazz._implements(_implement);
        }
        return clazz;
    }

    public GeneratedClass _class(String name, GeneratedClass _extends, Class<?>[] _implements) {
        GeneratedClass clazz = this._class(1, name);
        clazz._extends(_extends);
        for (Class<?> _implement : _implements) {
            clazz._implements(_implement);
        }
        return clazz;
    }

    public GeneratedClass _class(String name, TypeReference _extends, Class<?>[] _implements) {
        GeneratedClass clazz = this._class(1, name);
        clazz._extends(_extends);
        for (Class<?> _implement : _implements) {
            clazz._implements(_implement);
        }
        return clazz;
    }

    public GeneratedClass _class(int modifiers, String name, GeneratedClass _extends, Class<?>[] _implements) {
        GeneratedClass clazz = this._class(modifiers, name);
        clazz._extends(_extends);
        for (Class<?> _implement : _implements) {
            clazz._implements(_implement);
        }
        return clazz;
    }

    public GeneratedClass _class(String name, Class<?>[] _implements) {
        GeneratedClass clazz = this._class(1, name);
        for (Class<?> _implement : _implements) {
            clazz._implements(_implement);
        }
        return clazz;
    }

    public GeneratedClass _class(int modifiers, String name, Class<?>[] _implements) {
        GeneratedClass clazz = this._class(modifiers, name);
        for (Class<?> _implement : _implements) {
            clazz._implements(_implement);
        }
        return clazz;
    }

    public GeneratedClass _getClass(String name) {
        if (this.classes.containsKey(name)) {
            return this.classes.get(name);
        }
        return null;
    }

    @Override
    public int compareTo(GeneratedPackage that) {
        return this.name.compareTo(that.name);
    }

    @Override
    public GeneratedClass _interface(int mods, String name) {
        try {
            return this._class(mods, name, GeneratedClassType.INTERFACE);
        }
        catch (ClassAlreadyExistsException caee) {
            return caee.getExistingClass();
        }
    }

    @Override
    public GeneratedClass _interface(String name) throws ClassAlreadyExistsException {
        return this._interface(1, name);
    }

    @Override
    public GeneratedClass _annotationTypeDeclaration(String name) throws ClassAlreadyExistsException {
        return this._class(1, name, GeneratedClassType.ANNOTATION_TYPE_DECL);
    }

    @Override
    public GeneratedClass _enum(String name) throws ClassAlreadyExistsException {
        return this._class(1, name, GeneratedClassType.ENUM);
    }

    public ResourceFile addResourceFile(ResourceFile rsrc) {
        this.resources.add(rsrc);
        return rsrc;
    }

    public boolean hasResourceFile(String name) {
        for (ResourceFile r : this.resources) {
            if (!r.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Iterator<ResourceFile> propertyFiles() {
        return this.resources.iterator();
    }

    @Override
    public GeneratedJavaDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new GeneratedJavaDocComment(this.owner());
        }
        return this.jdoc;
    }

    public void remove(TypeReference c) {
        if (c._package() != this) {
            throw new IllegalArgumentException("the specified class is not a member of this package, or it is a referenced class");
        }
        this.classes.remove(c.name());
        if (this.upperCaseClassMap != null) {
            this.upperCaseClassMap.remove(c.name().toUpperCase());
        }
    }

    public TypeReference ref(String name) throws ClassNotFoundException {
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("TypeReference name contains '.': " + name);
        }
        String n = "";
        if (!this.isUnnamed()) {
            n = this.name + '.';
        }
        n = n + name;
        return this.owner.ref(Class.forName(n));
    }

    public GeneratedPackage subPackage(String pkg) {
        if (this.isUnnamed()) {
            return this.owner()._package(pkg);
        }
        return this.owner()._package(this.name + '.' + pkg);
    }

    @Override
    public Iterator<GeneratedClass> classes() {
        return this.classes.values().iterator();
    }

    public boolean isDefined(String classLocalName) {
        Iterator<GeneratedClass> itr = this.classes();
        while (itr.hasNext()) {
            if (!itr.next().name().equals(classLocalName)) continue;
            return true;
        }
        return false;
    }

    public final boolean isUnnamed() {
        return this.name.length() == 0;
    }

    public String name() {
        return this.name;
    }

    @Override
    public final CodeModel owner() {
        return this.owner;
    }

    @Override
    public GeneratedAnnotationUse annotate(TypeReference clazz) {
        if (this.isUnnamed()) {
            throw new IllegalArgumentException("the root package cannot be annotated");
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        GeneratedAnnotationUse a = new GeneratedAnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public GeneratedAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner.ref(clazz));
    }

    @Override
    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<GeneratedAnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        return Collections.unmodifiableList(this.annotations);
    }

    File toPath(File dir) {
        if (this.name == null) {
            return dir;
        }
        return new File(dir, this.name.replace('.', '/'));
    }

    @Override
    public void declare(Formatter f) {
        if (this.name.length() != 0) {
            f.p("package").p(this.name).p(';').nl();
        }
    }

    @Override
    public void generate(Formatter f) {
        f.p(this.name);
    }

    void build(CodeWriter src, CodeWriter res) throws IOException {
        for (GeneratedClass c : this.classes.values()) {
            if (c.isHidden()) continue;
            Formatter f = this.createJavaSourceFileWriter(src, c.name());
            f.write(c);
            f.close();
        }
        if (this.annotations != null || this.jdoc != null) {
            Formatter f = this.createJavaSourceFileWriter(src, "package-info");
            if (this.jdoc != null) {
                f.g(this.jdoc);
            }
            if (this.annotations != null) {
                for (GeneratedAnnotationUse a : this.annotations) {
                    f.g(a).nl();
                }
            }
            f.d(this);
            f.close();
        }
        for (ResourceFile rsrc : this.resources) {
            CodeWriter cw = rsrc.isResource() ? res : src;
            BufferedOutputStream os = new BufferedOutputStream(cw.openBinary(this, rsrc.name()));
            rsrc.build(os);
            ((OutputStream)os).close();
        }
    }

    int countArtifacts() {
        int r = 0;
        for (GeneratedClass c : this.classes.values()) {
            if (c.isHidden()) continue;
            ++r;
        }
        if (this.annotations != null || this.jdoc != null) {
            ++r;
        }
        return r += this.resources.size();
    }

    private Formatter createJavaSourceFileWriter(CodeWriter src, String className) throws IOException {
        BufferedWriter bw = new BufferedWriter(src.openSource(this, className + ".java"));
        return new Formatter(new PrintWriter(bw));
    }
}

