/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.devkit.model.code.AbstractGenerifiable;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.ClassContainer;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.EnumConstant;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClassType;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedJavaDocComment;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Generifiable;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.TypedAnnotationWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedClass
extends TypeReference
implements Declaration,
ClassContainer,
Generifiable,
Annotable,
Documentable {
    public static final String MULE_CONTEXT_JAVADOC = "Mule Context";
    public static final String MULE_CONTEXT_FIELD_NAME = "muleContext";
    public static final String FLOW_CONSTRUCT_JAVADOC = "Flow Construct";
    public static final String FLOW_CONSTRUCT_FIELD_NAME = "flowConstruct";
    private String name;
    private Modifiers mods;
    private TypeReference superClass;
    private final Set<TypeReference> interfaces = new TreeSet<TypeReference>();
    final Map<String, GeneratedField> fields = new LinkedHashMap<String, GeneratedField>();
    private GeneratedBlock init;
    private GeneratedJavaDocComment jdoc;
    private final List<GeneratedMethod> constructors = new ArrayList<GeneratedMethod>();
    private final List<GeneratedMethod> methods = new ArrayList<GeneratedMethod>();
    private Map<String, GeneratedClass> classes;
    private boolean hideFile;
    public Object metadata;
    private String directBlock;
    private ClassContainer outer;
    private final GeneratedClassType classType;
    private final Map<String, EnumConstant> enumConstantsByName = new LinkedHashMap<String, EnumConstant>();
    private List<GeneratedAnnotationUse> annotations;
    private final AbstractGenerifiable generifiable = new AbstractGenerifiable(){

        protected CodeModel owner() {
            return GeneratedClass.this.owner();
        }
    };

    GeneratedClass(ClassContainer parent, int mods, String name, GeneratedClassType classTypeval) {
        this(mods, name, parent, parent.owner(), classTypeval);
    }

    GeneratedClass(CodeModel owner, int mods, String name) {
        this(mods, name, null, owner);
    }

    private GeneratedClass(int mods, String name, ClassContainer parent, CodeModel owner) {
        this(mods, name, parent, owner, GeneratedClassType.CLASS);
    }

    private GeneratedClass(int mods, String name, ClassContainer parent, CodeModel owner, GeneratedClassType classTypeVal) {
        super(owner);
        if (name != null) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException("TypeReference name empty");
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                String msg = "TypeReference name " + name + " contains illegal character" + " for beginning of identifier: " + name.charAt(0);
                throw new IllegalArgumentException(msg);
            }
            for (int i = 1; i < name.length(); ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                String msg = "TypeReference name " + name + " contains illegal character " + name.charAt(i);
                throw new IllegalArgumentException(msg);
            }
        }
        this.classType = classTypeVal;
        this.mods = this.isInterface() ? Modifiers.forInterface(mods) : Modifiers.forClass(mods);
        this.name = name;
        this.outer = parent;
    }

    public final boolean isAnonymous() {
        return this.name == null;
    }

    public GeneratedClass _extends(TypeReference superClass) {
        if (this.classType == GeneratedClassType.INTERFACE) {
            if (superClass.isInterface()) {
                return this._implements(superClass);
            }
            throw new IllegalArgumentException("unable to set the super class for an interface");
        }
        if (superClass == null) {
            throw new NullPointerException();
        }
        for (TypeReference o = superClass.outer(); o != null; o = o.outer()) {
            if (this != o) continue;
            throw new IllegalArgumentException("Illegal class inheritance loop.  Outer class " + this.name + " may not subclass from inner class: " + o.name());
        }
        this.superClass = superClass;
        return this;
    }

    public GeneratedClass _extends(Class<?> superClass) {
        return this._extends(this.owner().ref(superClass));
    }

    @Override
    public TypeReference _extends() {
        if (this.superClass == null) {
            this.superClass = this.owner().ref(Object.class);
        }
        return this.superClass;
    }

    public GeneratedClass _implements(TypeReference iface) {
        this.interfaces.add(iface);
        return this;
    }

    public GeneratedClass _implements(Class<?> iface) {
        return this._implements(this.owner().ref(iface));
    }

    @Override
    public Iterator<TypeReference> _implements() {
        return this.interfaces.iterator();
    }

    @Override
    public String name() {
        return this.name;
    }

    public EnumConstant enumConstant(String name) {
        EnumConstant ec = this.enumConstantsByName.get(name);
        if (null == ec) {
            ec = new EnumConstant(this, name);
            this.enumConstantsByName.put(name, ec);
        }
        return ec;
    }

    @Override
    public String fullName() {
        if (this.outer instanceof GeneratedClass) {
            return ((GeneratedClass)this.outer).fullName() + '.' + this.name();
        }
        GeneratedPackage p = this._package();
        if (p.isUnnamed()) {
            return this.name();
        }
        return p.name() + '.' + this.name();
    }

    @Override
    public String binaryName() {
        if (this.outer instanceof GeneratedClass) {
            return ((GeneratedClass)this.outer).binaryName() + '$' + this.name();
        }
        return this.fullName();
    }

    @Override
    public boolean isInterface() {
        return this.classType == GeneratedClassType.INTERFACE;
    }

    @Override
    public boolean isAbstract() {
        return this.mods.isAbstract();
    }

    public GeneratedField field(int mods, Type type, String name) {
        return this.field(mods, type, name, null);
    }

    public GeneratedField field(int mods, Class<?> type, String name) {
        return this.field(mods, this.owner()._ref(type), name);
    }

    public GeneratedField field(int mods, Type type, String name, GeneratedExpression init) {
        GeneratedField f = new GeneratedField(this, Modifiers.forField(mods), type, name, init);
        if (this.fields.containsKey(name)) {
            throw new IllegalArgumentException("trying to create the same field twice: " + name);
        }
        this.fields.put(name, f);
        return f;
    }

    public boolean isAnnotationTypeDeclaration() {
        return this.classType == GeneratedClassType.ANNOTATION_TYPE_DECL;
    }

    @Override
    public GeneratedClass _annotationTypeDeclaration(String name) throws ClassAlreadyExistsException {
        return this._class(1, name, GeneratedClassType.ANNOTATION_TYPE_DECL);
    }

    @Override
    public GeneratedClass _enum(String name) throws ClassAlreadyExistsException {
        return this._class(1, name, GeneratedClassType.ENUM);
    }

    public GeneratedClass _enum(int mods, String name) throws ClassAlreadyExistsException {
        return this._class(mods, name, GeneratedClassType.ENUM);
    }

    public GeneratedClassType getClassType() {
        return this.classType;
    }

    public GeneratedField field(int mods, Class<?> type, String name, GeneratedExpression init) {
        return this.field(mods, this.owner()._ref(type), name, init);
    }

    public Map<String, GeneratedField> fields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public void removeField(GeneratedField field) {
        if (this.fields.remove(field.name()) != field) {
            throw new IllegalArgumentException();
        }
    }

    public GeneratedBlock init() {
        if (this.init == null) {
            this.init = new GeneratedBlock();
        }
        return this.init;
    }

    public GeneratedMethod constructor(int mods) {
        GeneratedMethod c = new GeneratedMethod(mods, this);
        this.constructors.add(c);
        return c;
    }

    public Iterator<GeneratedMethod> constructors() {
        return this.constructors.iterator();
    }

    public GeneratedMethod getConstructor(Type[] argTypes) {
        for (GeneratedMethod m : this.constructors) {
            if (!m.hasSignature(argTypes)) continue;
            return m;
        }
        return null;
    }

    public GeneratedMethod method(int mods, Type type, String name) {
        GeneratedMethod m = new GeneratedMethod(this, mods, type, name);
        this.methods.add(m);
        return m;
    }

    public GeneratedMethod method(int mods, Class<?> type, String name) {
        return this.method(mods, this.owner()._ref(type), name);
    }

    public GeneratedMethod method(int mods, Class<?> type, Class<?> narrowedType, String name) {
        return this.method(mods, this.owner()._ref(type).boxify().narrow(narrowedType), name);
    }

    public Collection<GeneratedMethod> methods() {
        return this.methods;
    }

    public GeneratedMethod getMethod(String name, Type[] argTypes) {
        for (GeneratedMethod m : this.methods) {
            if (!m.name().equals(name) || !m.hasSignature(argTypes)) continue;
            return m;
        }
        return null;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isPackage() {
        return false;
    }

    @Override
    public GeneratedPackage getPackage() {
        return this.parentContainer().getPackage();
    }

    @Override
    public GeneratedClass _class(int mods, String name) throws ClassAlreadyExistsException {
        return this._class(mods, name, GeneratedClassType.CLASS);
    }

    @Override
    public GeneratedClass _class(int mods, String name, boolean isInterface) throws ClassAlreadyExistsException {
        return this._class(mods, name, isInterface ? GeneratedClassType.INTERFACE : GeneratedClassType.CLASS);
    }

    @Override
    public GeneratedClass _class(int mods, String name, GeneratedClassType classTypeVal) throws ClassAlreadyExistsException {
        String NAME = CodeModel.isCaseSensitiveFileSystem ? name.toUpperCase() : name;
        if (this.getClasses().containsKey(NAME)) {
            throw new ClassAlreadyExistsException(this.getClasses().get(NAME));
        }
        GeneratedClass c = new GeneratedClass(this, mods, name, classTypeVal);
        this.getClasses().put(NAME, c);
        return c;
    }

    @Override
    public GeneratedClass _class(String name) {
        try {
            return this._class(1, name);
        }
        catch (ClassAlreadyExistsException caee) {
            return caee.getExistingClass();
        }
    }

    @Override
    public GeneratedClass _interface(int mods, String name) throws ClassAlreadyExistsException {
        return this._class(mods, name, GeneratedClassType.INTERFACE);
    }

    @Override
    public GeneratedClass _interface(String name) throws ClassAlreadyExistsException {
        return this._interface(1, name);
    }

    @Override
    public GeneratedJavaDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new GeneratedJavaDocComment(this.owner());
        }
        return this.jdoc;
    }

    public void hide() {
        this.hideFile = true;
    }

    public boolean isHidden() {
        return this.hideFile;
    }

    @Override
    public final Iterator<GeneratedClass> classes() {
        if (this.classes == null) {
            return Collections.emptyList().iterator();
        }
        return this.classes.values().iterator();
    }

    private Map<String, GeneratedClass> getClasses() {
        if (this.classes == null) {
            this.classes = new TreeMap<String, GeneratedClass>();
        }
        return this.classes;
    }

    public final TypeReference[] listClasses() {
        if (this.classes == null) {
            return new TypeReference[0];
        }
        return this.classes.values().toArray(new TypeReference[this.classes.values().size()]);
    }

    @Override
    public TypeReference outer() {
        if (this.outer.isClass()) {
            return (TypeReference)((Object)this.outer);
        }
        return null;
    }

    @Override
    public void declare(Formatter f) {
        if (this.jdoc != null) {
            f.nl().g(this.jdoc);
        }
        if (this.annotations != null) {
            for (GeneratedAnnotationUse annotation : this.annotations) {
                f.g(annotation).nl();
            }
        }
        f.g(this.mods).p(this.classType.getDeclarationToken()).id(this.name).d(this.generifiable);
        if (this.superClass != null && this.superClass != this.owner().ref(Object.class)) {
            f.nl().i().p("extends").g(this.superClass).nl().o();
        }
        if (!this.interfaces.isEmpty()) {
            if (this.superClass == null) {
                f.nl();
            }
            f.i().p(this.classType == GeneratedClassType.INTERFACE ? "extends" : "implements");
            f.g(this.interfaces);
            f.nl().o();
        }
        this.declareBody(f);
    }

    protected void declareBody(Formatter f) {
        f.p('{').nl().nl().i();
        boolean first = true;
        if (!this.enumConstantsByName.isEmpty()) {
            for (EnumConstant c : this.enumConstantsByName.values()) {
                if (!first) {
                    f.p(',').nl();
                }
                f.d(c);
                first = false;
            }
            f.p(';').nl();
        }
        for (GeneratedField field : this.fields.values()) {
            f.d(field);
        }
        if (this.init != null) {
            f.nl().p("static").s(this.init);
        }
        for (GeneratedMethod m : this.constructors) {
            f.nl().d(m);
        }
        for (GeneratedMethod m : this.methods) {
            f.nl().d(m);
        }
        if (this.classes != null) {
            for (GeneratedClass dc : this.classes.values()) {
                f.nl().d(dc);
            }
        }
        if (this.directBlock != null) {
            f.p(this.directBlock);
        }
        f.nl().o().p('}').nl();
    }

    public void direct(String string) {
        this.directBlock = this.directBlock == null ? string : this.directBlock + string;
    }

    @Override
    public final GeneratedPackage _package() {
        ClassContainer p = this.outer;
        while (!(p instanceof GeneratedPackage)) {
            p = p.parentContainer();
        }
        return (GeneratedPackage)p;
    }

    @Override
    public final ClassContainer parentContainer() {
        return this.outer;
    }

    @Override
    public TypeVariable generify(String name) {
        return this.generifiable.generify(name);
    }

    @Override
    public TypeVariable generify(String name, Class<?> bound) {
        return this.generifiable.generify(name, bound);
    }

    @Override
    public TypeVariable generify(String name, TypeReference bound) {
        return this.generifiable.generify(name, bound);
    }

    @Override
    public TypeVariable[] typeParams() {
        return this.generifiable.typeParams();
    }

    @Override
    protected TypeReference substituteParams(TypeVariable[] variables, List<TypeReference> bindings) {
        return this;
    }

    @Override
    public GeneratedAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner().ref(clazz));
    }

    @Override
    public GeneratedAnnotationUse annotate(TypeReference clazz) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        GeneratedAnnotationUse a = new GeneratedAnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<GeneratedAnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        return Collections.unmodifiableCollection(this.annotations);
    }

    public Modifiers mods() {
        return this.mods;
    }

    public GeneratedMethod setter(GeneratedField field) {
        GeneratedMethod setter = this.method(1, this.owner().VOID, "set" + StringUtils.capitalize((String)field.name()));
        setter.javadoc().add("Sets " + field.name());
        setter.javadoc().addParam("value Value to set");
        GeneratedVariable value = setter.param(field.type(), "value");
        setter.body().assign(ExpressionFactory._this().ref(field), value);
        return setter;
    }

    public GeneratedMethod setterOverride(GeneratedField field) {
        GeneratedMethod setter = this.setter(field);
        setter.annotate(Override.class);
        return setter;
    }

    public GeneratedMethod getter(GeneratedField field) {
        GeneratedMethod getter = this.method(1, field.type(), "get" + StringUtils.capitalize((String)field.name()));
        getter.javadoc().add("Retrieves " + field.name());
        getter.body()._return(ExpressionFactory._this().ref(field));
        return getter;
    }

    public List<GeneratedClass> superclasses() {
        ArrayList<GeneratedClass> superclasses = new ArrayList<GeneratedClass>();
        Iterator<GeneratedPackage> packageIterator = this.owner().packages();
        while (packageIterator.hasNext()) {
            Iterator<GeneratedClass> classIterator = packageIterator.next().classes();
            while (classIterator.hasNext()) {
                GeneratedClass classToBeTested = classIterator.next();
                if (classToBeTested == this || classToBeTested._extends() != this) continue;
                superclasses.add(classToBeTested);
            }
        }
        return superclasses;
    }

    private GeneratedClass directSuperclass() {
        List<GeneratedClass> superclasses = this.superclasses();
        if (superclasses.size() > 1) {
            throw new IllegalArgumentException("Cannot find the direct superclass of " + this.binaryName());
        }
        if (superclasses.size() == 0) {
            return null;
        }
        return superclasses.get(0);
    }

    public GeneratedClass topLevelClass() throws IllegalArgumentException {
        GeneratedClass topLevelClass = this;
        while (topLevelClass.directSuperclass() != null) {
            topLevelClass = topLevelClass.directSuperclass();
        }
        return topLevelClass;
    }

    @Override
    public String toString() {
        return "DefinedClass{name='" + this.name + '\'' + '}';
    }

    public boolean implementsClass(Class clazz) {
        Iterator<TypeReference> interfaces = this._implements();
        while (interfaces.hasNext()) {
            TypeReference interfaze = interfaces.next();
            if (!clazz.getName().equals(interfaze.fullName())) continue;
            return true;
        }
        return false;
    }

    public GeneratedField muleContextField() {
        if (!this.fields.containsKey(MULE_CONTEXT_FIELD_NAME)) {
            GeneratedField muleContext = this.field(2, this.owner().ref(MuleContext.class), MULE_CONTEXT_FIELD_NAME);
            muleContext.javadoc().add(MULE_CONTEXT_JAVADOC);
            this.setter(muleContext);
            this.getter(muleContext);
            this.fields.put(MULE_CONTEXT_FIELD_NAME, muleContext);
        }
        return this.fields.get(MULE_CONTEXT_FIELD_NAME);
    }

    public GeneratedField flowConstructField() {
        if (!this.fields.containsKey(FLOW_CONSTRUCT_FIELD_NAME)) {
            GeneratedField flowConstruct = this.field(2, this.owner().ref(FlowConstruct.class), FLOW_CONSTRUCT_FIELD_NAME);
            flowConstruct.javadoc().add(FLOW_CONSTRUCT_JAVADOC);
            this.setter(flowConstruct);
            this.getter(flowConstruct);
            this.fields.put(FLOW_CONSTRUCT_FIELD_NAME, flowConstruct);
        }
        return this.fields.get(FLOW_CONSTRUCT_FIELD_NAME);
    }
}

