/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.model.code.ArrayClass;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.DirectClass;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedAnonymousClass;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedClassType;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.NullType;
import org.mule.devkit.model.code.PrimitiveType;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.writer.FileCodeWriter;
import org.mule.devkit.model.code.writer.ProgressCodeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeModel {
    private HashMap<String, GeneratedPackage> packages = new HashMap();
    private final HashMap<Class<?>, ReferencedClass> refClasses = new HashMap();
    private CodeWriter codeWriter;
    private OutputStream registryBootstrapStream;
    public final NullType NULL = new NullType(this);
    public final PrimitiveType VOID = new PrimitiveType(this, "void", Void.class);
    public final PrimitiveType BOOLEAN = new PrimitiveType(this, "boolean", Boolean.class);
    public final PrimitiveType BYTE = new PrimitiveType(this, "byte", Byte.class);
    public final PrimitiveType SHORT = new PrimitiveType(this, "short", Short.class);
    public final PrimitiveType CHAR = new PrimitiveType(this, "char", Character.class);
    public final PrimitiveType INT = new PrimitiveType(this, "int", Integer.class);
    public final PrimitiveType FLOAT = new PrimitiveType(this, "float", Float.class);
    public final PrimitiveType LONG = new PrimitiveType(this, "long", Long.class);
    public final PrimitiveType DOUBLE = new PrimitiveType(this, "double", Double.class);
    protected static final boolean isCaseSensitiveFileSystem = CodeModel.getFileSystemCaseSensitivity();
    private TypeReference wildcard;
    public static final Map<Class<?>, Class<?>> primitiveToBox;
    public static final Map<Class<?>, Class<?>> boxToPrimitive;

    private static boolean getFileSystemCaseSensitivity() {
        try {
            if (System.getProperty("com.sun.codemodel.FileSystemCaseSensitive") != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return File.separatorChar == '/';
    }

    public CodeModel(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
    }

    public GeneratedPackage _package(String name) {
        GeneratedPackage p = this.packages.get(name);
        if (p == null) {
            p = new GeneratedPackage(name, this);
            this.packages.put(name, p);
        }
        return p;
    }

    public final GeneratedPackage rootPackage() {
        return this._package("");
    }

    public Iterator<GeneratedPackage> packages() {
        return this.packages.values().iterator();
    }

    public GeneratedClass _class(String fullyqualifiedName) throws ClassAlreadyExistsException {
        return this._class(fullyqualifiedName, GeneratedClassType.CLASS);
    }

    public TypeReference directClass(String name) {
        return new DirectClass(this, name);
    }

    public GeneratedClass _class(int mods, String fullyqualifiedName, GeneratedClassType t) throws ClassAlreadyExistsException {
        int idx = fullyqualifiedName.lastIndexOf(46);
        if (idx < 0) {
            return this.rootPackage()._class(fullyqualifiedName);
        }
        return this._package(fullyqualifiedName.substring(0, idx))._class(mods, fullyqualifiedName.substring(idx + 1), t);
    }

    public GeneratedClass _class(String fullyqualifiedName, GeneratedClassType t) throws ClassAlreadyExistsException {
        return this._class(1, fullyqualifiedName, t);
    }

    public GeneratedClass _getClass(String fullyQualifiedName) {
        int idx = fullyQualifiedName.lastIndexOf(46);
        if (idx < 0) {
            return this.rootPackage()._getClass(fullyQualifiedName);
        }
        return this._package(fullyQualifiedName.substring(0, idx))._getClass(fullyQualifiedName.substring(idx + 1));
    }

    public GeneratedClass newAnonymousClass(TypeReference baseType) {
        return new GeneratedAnonymousClass(baseType);
    }

    public GeneratedClass anonymousClass(TypeReference baseType) {
        return new GeneratedAnonymousClass(baseType);
    }

    public GeneratedClass anonymousClass(Class<?> baseType) {
        return this.anonymousClass(this.ref(baseType));
    }

    private void build(File destDir, PrintStream status) throws IOException {
        this.build(destDir, destDir, status);
    }

    private void build(File srcDir, File resourceDir, PrintStream status) throws IOException {
        CodeWriter src = new FileCodeWriter(srcDir);
        CodeWriter res = new FileCodeWriter(resourceDir);
        if (status != null) {
            src = new ProgressCodeWriter(src, status);
            res = new ProgressCodeWriter(res, status);
        }
        this.build(src, res);
    }

    private void build(File destDir) throws IOException {
        this.build(destDir, System.out);
    }

    private void build(File srcDir, File resourceDir) throws IOException {
        this.build(srcDir, resourceDir, System.out);
    }

    public void build() throws IOException {
        this.build(this.codeWriter);
    }

    private void build(CodeWriter out) throws IOException {
        this.build(out, out);
    }

    private void build(CodeWriter source, CodeWriter resource) throws IOException {
        GeneratedPackage[] pkgs;
        for (GeneratedPackage pkg : pkgs = this.packages.values().toArray(new GeneratedPackage[this.packages.size()])) {
            pkg.build(source, resource);
        }
        source.close();
        resource.close();
    }

    public int countArtifacts() {
        GeneratedPackage[] pkgs;
        int r = 0;
        for (GeneratedPackage pkg : pkgs = this.packages.values().toArray(new GeneratedPackage[this.packages.size()])) {
            r += pkg.countArtifacts();
        }
        return r;
    }

    public Type ref(TypeMirror typeMirror) {
        return this.ref(((Object)typeMirror).toString());
    }

    public TypeReference ref(Class<?> clazz) {
        ReferencedClass jrc = this.refClasses.get(clazz);
        if (jrc == null) {
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException(clazz + " is a primitive");
            }
            if (clazz.isArray()) {
                return new ArrayClass(this, this._ref(clazz.getComponentType()));
            }
            jrc = new ReferencedClass(clazz);
            this.refClasses.put(clazz, jrc);
        }
        return jrc;
    }

    public Type _ref(Class<?> c) {
        if (c.isPrimitive()) {
            return Type.parse(this, c.getName());
        }
        return this.ref(c);
    }

    public Type ref(String fullyQualifiedClassName) {
        try {
            return this.parseType(fullyQualifiedClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.refClass(fullyQualifiedClassName);
        }
    }

    private TypeReference refClass(String fullyQualifiedClassName) {
        try {
            return this.ref(Thread.currentThread().getContextClassLoader().loadClass(fullyQualifiedClassName));
        }
        catch (ClassNotFoundException e) {
            try {
                return this.ref(Class.forName(fullyQualifiedClassName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return new DirectClass(this, fullyQualifiedClassName);
            }
        }
    }

    public TypeReference wildcard() {
        if (this.wildcard == null) {
            this.wildcard = this.ref(Object.class).wildcard();
        }
        return this.wildcard;
    }

    public Type parseType(String name) throws ClassNotFoundException {
        if (name.endsWith("[]")) {
            return this.parseType(name.substring(0, name.length() - 2)).array();
        }
        try {
            return Type.parse(this, name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new TypeNameParser(name).parseTypeName();
        }
    }

    public OutputStream getRegistryBootstrapStream() throws IOException {
        if (this.registryBootstrapStream == null) {
            this.registryBootstrapStream = this.getCodeWriter().openBinary(null, "META-INF/services/org/mule/config/registry-bootstrap.properties");
        }
        return this.registryBootstrapStream;
    }

    public CodeWriter getCodeWriter() {
        return this.codeWriter;
    }

    static {
        HashMap<Class<Void>, Class<Object>> m1 = new HashMap<Class<Void>, Class<Object>>();
        HashMap m2 = new HashMap();
        m1.put(Boolean.class, Boolean.TYPE);
        m1.put(Byte.class, Byte.TYPE);
        m1.put(Character.class, Character.TYPE);
        m1.put(Double.class, Double.TYPE);
        m1.put(Float.class, Float.TYPE);
        m1.put(Integer.class, Integer.TYPE);
        m1.put(Long.class, Long.TYPE);
        m1.put(Short.class, Short.TYPE);
        m1.put(Void.class, Void.TYPE);
        for (Map.Entry e : m1.entrySet()) {
            m2.put(e.getValue(), e.getKey());
        }
        boxToPrimitive = Collections.unmodifiableMap(m1);
        primitiveToBox = Collections.unmodifiableMap(m2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReferencedClass
    extends TypeReference
    implements Declaration {
        private final Class<?> _class;

        ReferencedClass(Class<?> _clazz) {
            super(CodeModel.this);
            this._class = _clazz;
            assert (!this._class.isArray());
        }

        @Override
        public String name() {
            return this._class.getSimpleName().replace('$', '.');
        }

        @Override
        public String fullName() {
            return this._class.getName().replace('$', '.');
        }

        @Override
        public String binaryName() {
            return this._class.getName();
        }

        @Override
        public TypeReference outer() {
            Class<?> p = this._class.getDeclaringClass();
            if (p == null) {
                return null;
            }
            return CodeModel.this.ref(p);
        }

        @Override
        public GeneratedPackage _package() {
            String name = this.fullName();
            if (name.indexOf(91) != -1) {
                return CodeModel.this._package("");
            }
            int idx = name.lastIndexOf(46);
            if (idx < 0) {
                return CodeModel.this._package("");
            }
            return CodeModel.this._package(name.substring(0, idx));
        }

        @Override
        public TypeReference _extends() {
            Class<?> sp = this._class.getSuperclass();
            if (sp == null) {
                if (this.isInterface()) {
                    return this.owner().ref(Object.class);
                }
                return null;
            }
            return CodeModel.this.ref(sp);
        }

        @Override
        public Iterator<TypeReference> _implements() {
            final Class[] interfaces = this._class.getInterfaces();
            return new Iterator<TypeReference>(){
                private int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < interfaces.length;
                }

                @Override
                public TypeReference next() {
                    return CodeModel.this.ref(interfaces[this.idx++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean isInterface() {
            return this._class.isInterface();
        }

        @Override
        public boolean isAbstract() {
            return Modifier.isAbstract(this._class.getModifiers());
        }

        @Override
        public PrimitiveType getPrimitiveType() {
            Class<?> v = boxToPrimitive.get(this._class);
            if (v != null) {
                return ReferencedClass.parse(CodeModel.this, v.getName());
            }
            return null;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public void declare(Formatter f) {
        }

        @Override
        public TypeVariable[] typeParams() {
            return super.typeParams();
        }

        @Override
        protected TypeReference substituteParams(TypeVariable[] variables, List<TypeReference> bindings) {
            return this;
        }
    }

    private final class TypeNameParser {
        private final String s;
        private int idx;

        public TypeNameParser(String s) {
            this.s = s;
        }

        TypeReference parseTypeName() throws ClassNotFoundException {
            char ch;
            int start = this.idx;
            if (this.s.charAt(this.idx) == '?') {
                ++this.idx;
                this.ws();
                String head = this.s.substring(this.idx);
                if (head.startsWith("extends")) {
                    this.idx += 7;
                    this.ws();
                    return this.parseTypeName().wildcard();
                }
                if (head.startsWith("super")) {
                    throw new UnsupportedOperationException("? super T not implemented");
                }
                return CodeModel.this.refClass("java.lang.Object").wildcard();
            }
            while (this.idx < this.s.length() && (Character.isJavaIdentifierStart(ch = this.s.charAt(this.idx)) || Character.isJavaIdentifierPart(ch) || ch == '.')) {
                ++this.idx;
            }
            TypeReference clazz = CodeModel.this.refClass(this.s.substring(start, this.idx));
            return this.parseSuffix(clazz);
        }

        private TypeReference parseSuffix(TypeReference clazz) throws ClassNotFoundException {
            if (this.idx == this.s.length()) {
                return clazz;
            }
            char ch = this.s.charAt(this.idx);
            if (ch == '<') {
                return this.parseSuffix(this.parseArguments(clazz));
            }
            if (ch == '[') {
                if (this.s.charAt(this.idx + 1) == ']') {
                    this.idx += 2;
                    return this.parseSuffix(clazz.array());
                }
                throw new IllegalArgumentException("Expected ']' but found " + this.s.substring(this.idx + 1));
            }
            return clazz;
        }

        private void ws() {
            while (Character.isWhitespace(this.s.charAt(this.idx)) && this.idx < this.s.length()) {
                ++this.idx;
            }
        }

        private TypeReference parseArguments(TypeReference rawType) throws ClassNotFoundException {
            if (this.s.charAt(this.idx) != '<') {
                throw new IllegalArgumentException();
            }
            ++this.idx;
            ArrayList<TypeReference> args = new ArrayList<TypeReference>();
            while (this.idx < this.s.length()) {
                args.add(this.parseTypeName());
                char ch = this.s.charAt(this.idx);
                ++this.idx;
                if (ch == ',') continue;
                break;
            }
            return rawType.narrow(args.toArray(new TypeReference[args.size()]));
        }
    }
}

