/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.model.code.Assignment;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ContinueStatement;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.GeneratedBreak;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedDoLoop;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedForLoop;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedLabel;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedReturn;
import org.mule.devkit.model.code.GeneratedSwitch;
import org.mule.devkit.model.code.GeneratedThrow;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.GeneratedWhileLoop;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneratedBlock
implements Generable,
Statement {
    private final List<Object> content = new ArrayList<Object>();
    private boolean bracesRequired = true;
    private boolean indentRequired = true;
    private int pos;

    public GeneratedBlock() {
        this(true, true);
    }

    public GeneratedBlock(boolean bracesRequired, boolean indentRequired) {
        this.bracesRequired = bracesRequired;
        this.indentRequired = indentRequired;
    }

    public List<Object> getContents() {
        return Collections.unmodifiableList(this.content);
    }

    private <T> T insert(T statementOrDeclaration) {
        this.content.add(this.pos, statementOrDeclaration);
        ++this.pos;
        return statementOrDeclaration;
    }

    public int pos() {
        return this.pos;
    }

    public int pos(int newPos) {
        int r = this.pos;
        if (newPos > this.content.size() || newPos < 0) {
            throw new IllegalArgumentException();
        }
        this.pos = newPos;
        return r;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public GeneratedVariable decl(Type type, String name) {
        return this.decl(0, type, name, null);
    }

    public GeneratedVariable decl(Type type, String name, GeneratedExpression init) {
        return this.decl(0, type, name, init);
    }

    public GeneratedVariable decl(int mods, Type type, String name, GeneratedExpression init) {
        GeneratedVariable v = new GeneratedVariable(Modifiers.forVar(mods), type, name, init);
        this.insert(v);
        this.bracesRequired = true;
        this.indentRequired = true;
        return v;
    }

    public GeneratedBlock assign(AssignmentTarget lhs, GeneratedExpression exp) {
        this.insert(new Assignment(lhs, exp));
        return this;
    }

    public GeneratedBlock assignPlus(AssignmentTarget lhs, GeneratedExpression exp) {
        this.insert(new Assignment(lhs, exp, "+"));
        return this;
    }

    public GeneratedInvocation invoke(GeneratedExpression expr, String method) {
        GeneratedInvocation i = new GeneratedInvocation(expr, method);
        this.insert(i);
        return i;
    }

    public GeneratedInvocation invoke(GeneratedExpression expr, GeneratedMethod method) {
        return this.insert(new GeneratedInvocation(expr, method));
    }

    public GeneratedInvocation staticInvoke(TypeReference type, String method) {
        return this.insert(new GeneratedInvocation(type, method));
    }

    public GeneratedInvocation invoke(String method) {
        return this.insert(new GeneratedInvocation((GeneratedExpression)null, method));
    }

    public GeneratedInvocation invoke(GeneratedMethod method) {
        return this.insert(new GeneratedInvocation((GeneratedExpression)null, method));
    }

    public GeneratedBlock add(Statement s) {
        this.insert(s);
        return this;
    }

    public GeneratedConditional _if(GeneratedExpression expr) {
        return this.insert(new GeneratedConditional(expr));
    }

    public GeneratedForLoop _for() {
        return this.insert(new GeneratedForLoop());
    }

    public GeneratedWhileLoop _while(GeneratedExpression test) {
        return this.insert(new GeneratedWhileLoop(test));
    }

    public GeneratedSwitch _switch(GeneratedExpression test) {
        return this.insert(new GeneratedSwitch(test));
    }

    public GeneratedDoLoop _do(GeneratedExpression test) {
        return this.insert(new GeneratedDoLoop(test));
    }

    public GeneratedTry _try() {
        return this.insert(new GeneratedTry());
    }

    public void _return() {
        this.insert(new GeneratedReturn(null));
    }

    public void _return(GeneratedExpression exp) {
        this.insert(new GeneratedReturn(exp));
    }

    public void _throw(GeneratedExpression exp) {
        this.insert(new GeneratedThrow(exp));
    }

    public void _break() {
        this._break(null);
    }

    public void _break(GeneratedLabel label) {
        this.insert(new GeneratedBreak(label));
    }

    public GeneratedLabel label(String name) {
        GeneratedLabel l = new GeneratedLabel(name);
        this.insert(l);
        return l;
    }

    public void _continue(GeneratedLabel label) {
        this.insert(new ContinueStatement(label));
    }

    public void _continue() {
        this._continue(null);
    }

    public GeneratedBlock block() {
        GeneratedBlock b = new GeneratedBlock();
        b.bracesRequired = false;
        b.indentRequired = false;
        return this.insert(b);
    }

    public Statement directStatement(final String source) {
        Statement s = new Statement(){

            public void state(Formatter f) {
                f.p(source).nl();
            }
        };
        this.add(s);
        return s;
    }

    @Override
    public void generate(Formatter f) {
        if (this.bracesRequired) {
            f.p('{').nl();
        }
        if (this.indentRequired) {
            f.i();
        }
        this.generateBody(f);
        if (this.indentRequired) {
            f.o();
        }
        if (this.bracesRequired) {
            f.p('}');
        }
    }

    void generateBody(Formatter f) {
        for (Object o : this.content) {
            if (o instanceof Declaration) {
                f.d((Declaration)o);
                continue;
            }
            f.s((Statement)o);
        }
    }

    public GeneratedForEach forEach(Type varType, String name, GeneratedExpression collection) {
        return this.insert(new GeneratedForEach(varType, name, collection));
    }

    @Override
    public void state(Formatter f) {
        f.g(this);
        if (this.bracesRequired) {
            f.nl();
        }
    }
}

