/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.apidoc;

import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.param.MetaDataKeyParamAffectsType;
import org.mule.devkit.model.apidoc.misc.TypeLinkCreator;

public class Variable extends AbstractElement {

    private String javaTypeName;
    private String fullQualifiedJavaTypeName;
    private String defaultValue;
    private Boolean isOptional = false;
    private Boolean isRefOnly = false;
    private Boolean isPayload = false;
    private MetaDataKeyParamAffectsType metaDataKeyParam;

    public String defaultValue() {
        return setEmptyForNull(defaultValue);
    }

    public Boolean isOptional() {
        return isOptional || StringUtils.isNotBlank(defaultValue());
    }

    public Boolean isRefOnly() {
        return isRefOnly;
    }

    public String javaTypeName() {
        return javaTypeName;
    }

    public String javaTypeFullQualifiedName() {
        return fullQualifiedJavaTypeName;
    }

    public void defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void isOptional(Boolean isOptional) {
        this.isOptional = isOptional;
    }

    public void isRefOnly(Boolean isRefOnly) {
        this.isRefOnly = isRefOnly;
    }

    public void fullQualifiedJavaTypeName(String fullQualifiedJavaTypeName) {
        this.fullQualifiedJavaTypeName = fullQualifiedJavaTypeName;
    }

    public void javaTypeName(String javaTypeName) {
        this.javaTypeName = javaTypeName;
    }

    public void metaDataKeyParam(Optional<MetaDataKeyParamAffectsType> type) {
        this.metaDataKeyParam = type.isPresent() ? type.get() : null;
    }

    public boolean isDefaultPayload(){
        return "#[payload]".equals(defaultValue) || isPayload();
    }

    public Boolean isPayload() {
        return isPayload;
    }

    public void isPayload(Boolean isPayload) {
        this.isPayload = isPayload;
    }

    public boolean isMetaDataKey(){
        return metaDataKeyParam != null;
    }

    public Optional<MetaDataKeyParamAffectsType> metaDataKeyAffects(){
        return Optional.fromNullable(metaDataKeyParam);
    }

    public boolean isMetaDataType(){
        return javaTypeName.equals("Map<String,Object>") || javaTypeName.equals("List<Map<String,Object>");
    }

    public boolean isInjectable(){
        return javaTypeName.endsWith("MuleEvent") || javaTypeName.endsWith("MuleMessage");
    }

    public String javaTypeLink(){
        return TypeLinkCreator.getInstance().create(fullQualifiedJavaTypeName);
    }

    @Override
    public String xsdName() {
        return javaName();
    }
}
