/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.ws;

import java.lang.annotation.*;

/**
 * The method marked as @WsdlBodyEnricher will receive a Document representing the soap message body (which is the application payload),
 * and must also return a the same object, with the modified body.
 *
 * Signature has to be exactly the following:
 *
 * public Document exampleBodyEnricher(ServiceDefinition serviceDefinition, String operationName, Document payload)
 *
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface WsdlBodyEnricher {

}
