/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation marks a method inside a {@link org.mule.api.annotations.components.ConnectionManagement} as the responsible for disposing
 * a connection. It will be called by the connector's connection manager.
 *
 * When a connection lies in the pool without use for more than the configured time,
 * then the method annotated with @Disconnect is invoked and subsequently the @Connect method. Also, when the @InvalidateConnectionOn
 * annotation is used on a method to catch Exceptions, then the @Disconnect method likewise is invoked with the subsequent reconnect
 * Disconnect method must:
 * <ol>
 *     <li>be public
 *     <li>Take no input parameters
 *     <li>Return {@code void} type
 * </ol>
 *
 * @see org.mule.api.annotations.components.ConnectionManagement
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Disconnect {
}

