/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.metadata;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.SOURCE;

/**
 * @author MuleSoft, Inc
 *
 * Defines the field to be injected of type {@link org.mule.devkit.api.metadata.ConnectorMetaDataCache}
 * into a {@link org.mule.api.annotations.components.MetaDataCategory} component.
 *
 * This field will then contain an initialized {@link org.mule.devkit.api.metadata.ConnectorMetaDataCache} in order
 * for the category to use when retrieving the required metaData.
 *
 */
@Target(FIELD)
@Retention(SOURCE)
@Documented
public @interface MetaDataCache
{

}