/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.param;

import java.lang.annotation.*;

/**
 * Specifies that {@link org.mule.api.annotations.Processor}/{@link org.mule.api.annotations.Source}/{@link org.mule.api.annotations.Filter}
 * String or List<String> parameter will not be evaluated, enabling each of them to receive a plain MEL into any operation.
 *
 * This is because DevKit's generated code tries to automatically resolve the expression, this way you can set MEL expressions without evaluating them.
 */
@Target(value = {ElementType.PARAMETER})
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Literal {
}
