/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.api.annotations.oauth;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * A class annotated with {@link OAuth} or {@link OAuth2} needs to have exactly one field annotated with @OAuthAccessToken.
 * The field must be of type String. When an @Processor method that is invoked, a OAuth
 * access token will be set in case the Resource Owner already authorized the Consumer, otherwise the method will not
 * be invoked and the Resource Owner will be redirected to the {@link OAuth#authorizationUrl()} or {@link OAuth2#authorizationUrl()}
 * depending on the class level annotation used.
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface OAuthAccessToken {

}