/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The use of this annotation will improve the Studio experience while using native queries in the MetaData propagation.
 * MetaDataNativeQueryOutputRetriever marks a method as a describer for {@link org.mule.common.metadata.MetaData} for output scenarios,
 * for a given {@link org.mule.common.metadata.MetaDataKey} when the current processor describing the output metadata is
 * a @Query one and the input is a native query (not DSQL).
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
public @interface MetaDataNativeQueryOutputRetriever
{

}
