/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations;

import java.lang.annotation.*;

/**
 * Method to test if a specific {@link org.mule.api.annotations.components.ConnectionManagement} config
 * is able to hit the endpoint. The "Test Connectivity" button of the configuration window will trigger this
 * method.
 *
 * The {@link TestConnectivity} method can be the same as {@link Connect} method, or a separate one with the same signature.
 *
 * Constrains for the Decoupled Test Connectivity method:
 * <ol>
 *     <li>Only one method can be annotated with @TestConnectivity.</li>
 *     <li>The method annotated with @TestConnectivity must have the exact same parameters the @Connect methods, in the same order.</li>
 *     <li>Method should declare throws ConnectionException.</li>
 * </ol>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface TestConnectivity {

    public String TEST_CONNECTION = "Test Connection...";

    /**
     * @return true if the concrete strategy can hit the API to determine if the parameters of it are properly populated
     */
    boolean active() default true;

    /**
     * @return the label that Studio must use when rendering the button
     */
    String label() default TEST_CONNECTION;
}
