/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation is meant to translate an <strong>DSQL</strong> query into a native one.
 * <br/>
 *
 * The method annotated must receive an {@link org.mule.common.query.DsqlQuery} parameter and return an {@link String}.
 * <br/>
 * This annotation must be within the {@link Connector} scope.
 * <br/>
 * It is recommended to extend {@link org.mule.common.query.DsqlQueryVisitor} to easily do the translation of your query.
 *
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface QueryTranslator {


}