/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.lifecycle;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This is a lifecycle annotation, since the handler will be injected in the common cycle when an exception occurs.
 * When an exception occurs in the method or module annotated with @{@link OnException} the handler declared in this
 * annotation will be called immediately, passing to the @{@link org.mule.api.annotations.Handle} the thrown exception
 * The scope of this annotations corresponds to a module or method context.
 * When used in a method, this will handle exceptions occurred in this
 * processor only. If a module level handler is also declared, it will be the common handler for all the processors.
 * No fallback from the specific to the common handlers exists, the method level handler will override the
 * module level one.
 *
 * @see org.mule.api.annotations.ReconnectOn
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.SOURCE)
public @interface OnException {

    Class handler();
}
