/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.api.annotations.rest;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Allows you to set parameters in the body of POST method calls. Define the POST
 * method with {@link RestCall} and set its parameters with {@link RestPostParam}.
 *
 * You can apply this annotation to {@link org.mule.api.annotations.Processor} method arguments or to connector
 * fields marked {@link org.mule.api.annotations.Configurable}. DevKit ensures that you apply this annotation only to POST methods.
 *
 * {@link org.mule.api.annotations.Processor} methods annotated with {@link RestPostParam} cannot use a non-annotated argument or a {@link org.mule.api.annotations.param.Payload} annotated argument.
 *
 * @see RestCall
 */
@Target(value = {ElementType.PARAMETER, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RestPostParam {
    String value();

    boolean ignoreIfEmpty() default false;
}
