/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.components;

import org.mule.api.annotations.AnnotationsConstants;

import java.lang.annotation.*;

/**
 * This annotation is used to define a basic authentication connection strategy. It must contain at least for methods annotated
 * with {@link org.mule.api.annotations.Connect}, {@link org.mule.api.annotations.Disconnect}, {@link org.mule.api.annotations.ValidateConnection}
 * and {@link org.mule.api.annotations.ConnectionIdentifier}.
 *
 * @see Configuration
 * @see org.mule.api.annotations.oauth.OAuth2
 * @see org.mule.api.annotations.Config
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface ConnectionManagement {

    /**
     * Name of the configuration element
     */
    String configElementName() default AnnotationsConstants.CONFIG_ELEMENT_NAME;

    /**
     * Provides a friendly name for the strategy.
     */
    String friendlyName();
}
