package org.mule.api.annotations.components;

import org.mule.api.annotations.AnnotationsConstants;

import java.lang.annotation.*;

/**
 * This annotation is used to define HTTP Authentication RFC2617 strategy
 * (see <a href="http://tools.ietf.org/html/rfc2617">http://tools.ietf.org/html/rfc2617</a>), where it assumes that the
 * custom component contains fields annotated with {@link org.mule.api.annotations.rest.BasicAuthUsername} and {@link org.mule.api.annotations.rest.BasicAuthPassword}.
 * <p>
 * Using the default values for {@link #headerName()} and {@link #prefix()}, if the user agent wishes to send the userid
 * "Aladdin" and password "open sesame", it would use the following header field:
 * <ul>
 *     <li>Authorization: Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==</li>
 * </ul>
 * </p>
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface HttpBasicAuth {

    /**
     * Name of the configuration element
     */
    String configElementName() default AnnotationsConstants.CONFIG_ELEMENT_NAME;

    /**
     * Provides a friendly name for the strategy.
     */
    String friendlyName();

    /**
     * Name of the header that will contain the username and password encoded in Base64
     */
    String headerName() default "Authorization";

    /**
     * Prefix that will be used be used before the username and password encoded into base64.
     */
    String prefix() default "Basic ";
}
