/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.api.annotations;


import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * This annotation marks a method inside an @{@link org.mule.api.annotations.Connector} scope as the responsible for creating
 * a connection. This method could have several parameters and them could contain annotations such as {@link org.mule.api.annotations.param.ConnectionKey} or {@link org.mule.api.annotations.display.Password}.
 * It is guaranteed that this method will be called before calling any message processor.
 * <br/>
 * <br/>
 * There are two restrictions though.
 *
 * <ol>
 *     <li>There can't be parameters with primitive types as {@code int},{@code bool},{@code short}, etc.</li>
 *     <br/>
 *     <li>The method's return type must be {@code void}</li>
 * </ol>
 *
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Connect {

    /**
     * <p> Defines the strategy to be used when managing connections. Two values are given out of the box. </p>
     * <bl>
     *     <li> {@link ConnectStrategy#MULTIPLE_INSTANCES} to be used when multiple connector instances can be used within the same key (like user name and password). This is intended for non thread safe environments. </li>
     *     <li> {@link ConnectStrategy#SINGLE_INSTANCE} to be used when only a single instance can be used within the same key (like user name and password). It is important to notice that the service client used here <strong>must be thread safe</strong></li>
     * </bl>
     */
    ConnectStrategy strategy() default ConnectStrategy.MULTIPLE_INSTANCES;

}
