/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.api.annotations.param;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks a parameter inside @{@link org.mule.api.annotations.Processor} as
 * the key for the metadata lookup. This lookup is resolved by @{@link org.mule.api.annotations.MetaDataRetriever} method by
 * executing the <strong>toString()</strong> method on the annotated parameter.
 * <br/>
 * <br/>
 * The default parameter affected for the lookup will be the one annotated with @{@link Default}("#[payload]"). ie, the parameter with the actual data.
 */
@Target(value = {ElementType.PARAMETER, ElementType.FIELD})
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface MetaDataKeyParam {
    /**
     * It reflects the target of the dynamic type. The default value is AUTO but can be changed to INPUT, OUTPUT or BOTH.
     */
    MetaDataKeyParamAffectsType affects() default MetaDataKeyParamAffectsType.AUTO;

    String[] labels() default "";
}
