package org.mule.api.annotations;

import java.lang.annotation.*;

/**
 * Method to test if a specific strategy is able to hit the endpoint
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface TestConnectivity {

    public String TEST_CONNECTION = "Test Connection...";

    /**
     * @return true if the concrete strategy can hit the API to determine if the parameters of it are properly populated
     */
    boolean active() default true;

    /**
     * @return the label that Studio must use when rendering the button
     */
    String label() default TEST_CONNECTION;
}
