package org.mule.api.annotations;

import java.lang.annotation.*;

/**
 * This annotation can be attached to any method annotated with {@link org.mule.api.annotations.Processor}.
 * It receives a list of exception classes to be catch.
 * <p/>
 * If the Processor/Source throw an exception that matches any of the {@link #exceptions()}, it will automatically
 * invalidate the connection.
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface ReconnectOn {
    Class<? extends Exception>[] exceptions();
}
