/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.api.annotations.rest;


import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation can be attached to a {@link org.mule.api.annotations.rest.RestCall} to optionally specify a
 * timeout in milliseconds for the rest call. If the rest call exceeds the specified time, a RuntimeException is going
 * to be thrown, unless an exception is specified for the timeout.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RestTimeout
{
    int timeout() default 0;

    Class<? extends RuntimeException> exception() default RuntimeException.class;
}
