package org.mule.api.annotations.components;

import org.mule.api.annotations.AnnotationsConstants;

import java.lang.annotation.*;

/**
 * This annotation is used to define a basic auth connection strategy. It must contain at least for methods annotated
 * with {@link org.mule.api.annotations.Connect}, {@link org.mule.api.annotations.Disconnect}, {@link org.mule.api.annotations.ValidateConnection}
 * and {@link org.mule.api.annotations.ConnectionIdentifier}.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface ConnectionManagement {

    /**
     * Name of the configuration element
     */
    String configElementName() default AnnotationsConstants.CONFIG_ELEMENT_NAME;

    /**
     * Provides a friendly name for the strategy.
     */
    String friendlyName();
}
