package org.mule.api.annotations;

import java.lang.annotation.*;

/**
 * Used to differentiate grouping data sense types at operation or class level.
 * Each category, {@link #value()}, has the ability to return types as well as describe them.
 */
@Target(value = {ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface MetaDataScope {

    /**
     * The class within the {@link #value()} must implement {@link MetaDataCategory}.
     * If not, the connector's compilation will fail
     */
    Class value();
}
