/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The method annotated with {@link MetaDataRetriever} describes the metadata
 * for the received metadata key parameter.
 * <br/> An {@link org.mule.common.metadata.MetaDataKey} parameter is required and also the method return type must be {@link org.mule.common.metadata.MetaData}.
 * <br/>
 * <br/>
 * To build up this metadata we recommend using {@link org.mule.common.metadata.builder.DefaultMetaDataBuilder}.
 * For more information about {@link org.mule.common.metadata.MetaData} see {@link org.mule.common.metadata.MetaDataModel}.
 * <br/>
 * <br/>
 * <strong>Extra information</strong>
 * <ol>
 *  <li>This annotation can be used inside an @{@link Connector} context or inside an @{@link MetaDataCategory}.</li>
 *  <br/>
 *  <li>There must be an @{@link MetaDataKeyRetriever} method already defined.</li>
 *  <br/>
 *  <li>When @{@link MetaDataOutputRetriever} is present at the same context this annotation will only work for input metadata.
 * scenarios ONLY.</li>
 * </ol>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface MetaDataRetriever {
}
