/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.module.components.managers;

import com.google.common.base.Optional;
import org.mule.devkit.model.module.components.connection.*;
import org.mule.devkit.model.module.components.exceptionhandler.OnExceptionHandlerComponent;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;

import java.util.List;
import java.util.Set;

/**
 *  This manager will handle the components bounded at Module level
 */
public interface ModuleComponentManager extends ComponentManager {

    /**
     * @return a {@link MetaDataCategoryComponent} if the
     * module has been annotated with {@link org.mule.api.annotations.MetaDataScope}.
     */
    Optional<MetaDataCategoryComponent> metaDataCategoryComponent();

    /**
     * @return a set of {@link MetaDataCategoryComponent} if the
     * module, or any of its processors, has been annotated with {@link org.mule.api.annotations.MetaDataScope}.
     */
    Set<MetaDataCategoryComponent> metaDataCategoryComponents();

    /**
     * @return a list of {@link org.mule.devkit.model.module.components.connection.ConnectionManagementComponent} if the module within its strategies is targeting at least one
     * Strategy annotated with {@link org.mule.api.annotations.components.ConnectionManagement}.
     */
    List<ConnectionManagementComponent> connectionManagementComponents();

    /**
     * @return a {@link OAuth2Component} if the module, within its strategies, is pointing to a concrete OAuth2
     * Strategy annotated with {@link org.mule.api.annotations.oauth.OAuth2}.
     */
    Optional<OAuth2Component> oauth2Component();

    /**
     * @return a {@link HttpBasicAuthComponent} if the module, within its strategies, is pointing to a concrete HttpBasicAuth
     * Strategy annotated with {@link org.mule.api.annotations.components.HttpBasicAuth}.
     */
    Optional<HttpBasicAuthComponent> httpBasicAuthComponent();

    /**
     * @return a list of {@link org.mule.devkit.model.module.components.connection.ConnectionManagementComponent} if the module within its strategies is targeting at least one
     * Strategy annotated with {@link org.mule.api.annotations.components.WsdlProvider}.
     */
    List<WsdlProviderComponent> wsdlProviderComponent();

    /**
     * @return a list of {@link org.mule.devkit.model.module.components.connection.ConfigurationComponent} if the module within its strategies is targeting at least one
     * Strategy annotated with {@link org.mule.api.annotations.components.Configuration}.
     */
    List<ConfigurationComponent> configurationComponents();

    List<ConnectionComponent> connectionComponents();

    Optional<ConnectionManagementComponent> connectionManagementOverride();

    Optional<OnExceptionHandlerComponent> handlerComponent();

    boolean hasConnectionManagedWsdlProvider();

}
