/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.model;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import java.util.List;

public interface Method<P extends Type> extends Identifiable<ExecutableElement>, Parentable<P> {
    List<Parameter<Method<P>>> getParameters();

    List<? extends TypeMirror> getThrownTypes();

    TypeMirror getReturnType();

    List<? extends TypeParameterElement> getTypeParameters();

    boolean hasOnlyOneChildElement();

    String getCapitalizedName();

    GenericType getReturnGenericType();

    boolean hasReturnGenericType(Class<?> clazz);

    Parameter getPayloadParameter();

    String friendlyName();

    String xsdName();
}
