/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model;

import com.google.common.base.Optional;

import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import java.util.List;

public interface GenericType {

    TypeMirror getType();

    Optional<Element> getElement();

    List<GenericType> getGenericTypeArguments();

    boolean hasMetaData();

    boolean isList();

    boolean isMap();

    boolean is(String typeName);

    boolean isMetaData();

    boolean isCollection();

    String fullQualifiedName();
}
