/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.model;

/**
 * This interface provides a way to interact with model elements that can
 * have javadoc comments and tags.
 */
public interface Documentable {

    /**
     * Checks if the element contains the specified tag in this javadoc
     * comments.
     *
     * @param tagName The name of the javadoc tag to check
     * @return true if it contains it, false otherwise
     */
    boolean hasJavaDocTag(String tagName);

    String getJavaDocSummary();

    String getJavaDocTagContent(String tagName);

    String getJavaDocParameterSummary(String paramName);

    /**
     * Returns the comment for the given exception class name. The class name should be exactly equal to the one
     * that appears in the javadoc.
     */
    String getThrowsComment(String exceptionClassName);
}
