package org.mule.devkit.model.module.components.exceptionhandler;

import com.google.common.base.Optional;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.components.ModuleComponent;
import org.mule.devkit.model.module.components.ProcessorComponent;

import java.lang.annotation.Annotation;
import java.util.List;

/**
 * @author Mulesoft, Inc
 */
public interface OnExceptionHandlerComponent extends ModuleComponent, ProcessorComponent {

    public Method getExceptionHandle();

    public Optional<String> getModuleInjectionSetter(String moduleName);

    /**
     * see {@link org.mule.devkit.model.Type#getMethodsAnnotatedWith(Class)}
     */
    List<Method<Type>> getMethodsAnnotatedWith(Class<? extends Annotation> annotation);
}
