/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.model.module;

import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.DeclaredType;

import org.mule.api.annotations.Paged;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;

import java.lang.annotation.Annotation;
import java.util.List;

public interface ProcessorMethod extends Method<Type> {
    /**
     * Use {@link #reconnectOn()} instead
     */
    @Deprecated
    DeclaredType invalidateConnectionOn();

    /**
     * Use {@link #reconnectOn()} instead
     */
    @Deprecated
    DeclaredType invalidateAccessTokenOn();

    List<AnnotationValue> reconnectOn();

    DeclaredType metaDataScope();

    /**
     * Returns the content of a field for a given annotation. Useful when the type of a {@code annotationField} within the
     * {@code anAnnotation} is Class or Class[]. Use:
     * <ul>
     *     <li> Annotation has a field type of: Class
     *         (DeclaredType) getAnnotationFieldValue(SomeAnnotation.class, "value")
     *     </li>
     *     <li> Annotation has a field type of: Class[]
     *         (List<AnnotationValue>) getAnnotationFieldValue(SomeAnnotation.class,"values")
     *     </li>
     * <ul/>
     */
    <T> T getAnnotationFieldValue(Class<? extends Annotation> anAnnotation, String annotationField);

    boolean isIntercepting();

    boolean isOAuthProtected();

    public boolean canBeUsedInConnectionManagement();

    public ManagedConnectionModule getManagedConnectionModule();

    public boolean canBeUsedInOAuthManagement();

    public OAuthModule getOAuthModule();

    boolean hasQuery();

    Parameter getQueryParameter();

    boolean hasQueryParts();

    boolean hasQueryTranslator();

    public boolean isPaged();

    public Paged getPagingAnnotation();

    boolean hasDynamicMetaData();

    boolean hasDynamicInputMetadata();

    boolean hasDynamicOutputMetaData();

    Parameter getInputMetaDataKeyParameter();

    Parameter getOutputMetaDataKeyParameter();

    boolean hasStaticKeyMetaData();

    boolean hasStaticKeyInputMetaData();

    Parameter getStaticKeyInputMetaData();

    boolean hasStaticKeyOutputMetaData();

    MetaDataStaticKey getStaticKeyOutputMetaData();

    boolean hasMetaDataScope();
}
