/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.model;

import java.lang.annotation.Annotation;
import java.util.List;

import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

/**
 * Regular Java Type
 */
public interface Type extends Identifiable<TypeElement>, Typeable {

    List<Method<Type>> getMethodsAnnotatedWith(Class<? extends Annotation> annotation);

    List<Field<Type>> getFields();

    /**
     * Get all methods defined in this class
     *
     * @return A list containing all the methods defined in this class
     */
    List<Method<Type>> getMethods();

    boolean hasNoArgConstructor();

    boolean isParametrized();

    boolean hasFieldAnnotatedWith(Class<? extends Annotation> annotation);

    boolean isInterface();

    boolean isPrimitive();

    String getPathToSourceFile();

    org.mule.devkit.model.Package getPackage();

    String getClassName();

    Name getQualifiedName();

    String getPackageName();

    /**
     * Returns whether this type inherits from the provided class
     *
     * @param clazz class to validate inheritance
     * @return whether the type is subclass of the provided class or not
     */
    boolean inheritsFrom(Class clazz);

    /**
     * Returns whether this type inherits from the provided type
     *
     * @param type Type to validate inheritance
     * @return whether the type is subclass of the provided class or not
     */
    public boolean inheritsFrom(Type type);

    List<Field<Type>> getInheritedFields();

    Type getSuperClass();

    boolean hasSuperClass();

    boolean isDsqlQueryObject();
}
